/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.client.screens;

import com.direwolf20.justdirethings.client.screens.basescreens.BaseMachineScreen;
import com.direwolf20.justdirethings.client.screens.standardbuttons.ToggleButtonFactory;
import com.direwolf20.justdirethings.client.screens.widgets.GrayscaleButton;
import com.direwolf20.justdirethings.client.screens.widgets.ToggleButton;
import com.direwolf20.justdirethings.common.blockentities.ParadoxMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.BaseMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.FluidMachineBE;
import com.direwolf20.justdirethings.common.blockentities.basebe.PoweredMachineBE;
import com.direwolf20.justdirethings.common.containers.ParadoxMachineContainer;
import com.direwolf20.justdirethings.common.network.data.ParadoxMachineSnapshotPayload;
import com.direwolf20.justdirethings.common.network.data.ParadoxRenderPayload;
import com.direwolf20.justdirethings.util.MagicHelpers;
import com.direwolf20.justdirethings.util.MiscTools;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;

public class ParadoxMachineScreen
extends BaseMachineScreen<ParadoxMachineContainer> {
    protected static final ResourceLocation PARADOXBAR = ResourceLocation.fromNamespaceAndPath((String)"justdirethings", (String)"textures/gui/paradoxbar.png");
    private boolean renderParadox = false;
    private int targetType = 0;

    public ParadoxMachineScreen(ParadoxMachineContainer container, Inventory inv, Component name) {
        super(container, inv, name);
        BaseMachineBE baseMachineBE = container.baseMachineBE;
        if (baseMachineBE instanceof ParadoxMachineBE) {
            ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)baseMachineBE;
            this.renderParadox = paradoxMachineBE.renderParadox;
            this.targetType = paradoxMachineBE.targetType;
        }
    }

    @Override
    public void init() {
        super.init();
        this.addSnapshotButton();
        this.addRenderButton();
        this.addTargetButton();
    }

    @Override
    public void setTopSection() {
        this.extraWidth = 80;
        this.extraHeight = 0;
    }

    public void addSnapshotButton() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.SNAPSHOT_AREA_BUTTON(this.getGuiLeft() + 116, this.topSectionTop + 62, b -> PacketDistributor.sendToServer((CustomPacketPayload)new ParadoxMachineSnapshotPayload(), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }

    public void addRenderButton() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.RENDERPARADOXBUTTON(this.getGuiLeft() + 98, this.topSectionTop + 62, this.renderParadox, b -> {
            this.renderParadox = !this.renderParadox;
            ((GrayscaleButton)b).toggleActive();
            this.saveSettings();
        }));
    }

    public void addTargetButton() {
        this.addRenderableWidget((GuiEventListener)ToggleButtonFactory.PARADOXTARGETBUTTON(this.getGuiLeft() + 56, this.topSectionTop + 38, this.targetType, b -> {
            this.targetType = ((ToggleButton)b).getTexturePosition();
            this.saveSettings();
        }));
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        PacketDistributor.sendToServer((CustomPacketPayload)new ParadoxRenderPayload(this.renderParadox, this.targetType), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof ParadoxMachineBE) {
            ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)baseMachineBE;
            guiGraphics.blit(PARADOXBAR, this.topSectionLeft + this.topSectionWidth - 18 - 5, this.topSectionTop + 5, 0.0f, 0.0f, 18, 72, 36, 72);
            float maxEnergy = paradoxMachineBE.getMaxParadoxEnergy();
            float height = 70.0f;
            if (maxEnergy > 0.0f && paradoxMachineBE.paradoxEnergy > 0.0f) {
                float remaining = paradoxMachineBE.paradoxEnergy * height / maxEnergy;
                long time = System.currentTimeMillis();
                int color = Color.HSBtoRGB((float)(time % 10800L) / 10800.0f, 1.0f, 1.0f);
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color & 0xFF;
                guiGraphics.setColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
                guiGraphics.blit(PARADOXBAR, this.topSectionLeft + this.topSectionWidth - 18 - 5 + 1, this.topSectionTop + this.getEnergyBarOffset() + 72 - 2 - (int)remaining, 19.0f, 69.0f - remaining, 17, (int)remaining + 1, 36, 72);
            }
        }
    }

    @Override
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        super.renderTooltip(pGuiGraphics, pX, pY);
        this.paradoxBarTooltip(pGuiGraphics, pX, pY);
    }

    public void paradoxBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof ParadoxMachineBE) {
            ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)baseMachineBE;
            if (MiscTools.inBounds(this.topSectionLeft + this.topSectionWidth - 18 - 5, this.topSectionTop + 5, 18, 72, pX, pY)) {
                String energyFormatted = String.format("%.2f", Float.valueOf(paradoxMachineBE.paradoxEnergy));
                pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.paradoxenergy", (Object[])new Object[]{energyFormatted, Float.valueOf(paradoxMachineBE.getMaxParadoxEnergy())}))), pX, pY);
            }
        }
    }

    @Override
    public void powerBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof ParadoxMachineBE) {
            ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)baseMachineBE;
            baseMachineBE = this.baseMachineBE;
            if (baseMachineBE instanceof PoweredMachineBE) {
                PoweredMachineBE poweredMachineBE = (PoweredMachineBE)((Object)baseMachineBE);
                if (MiscTools.inBounds(this.topSectionLeft + 5, this.topSectionTop + 5, 18, 72, pX, pY)) {
                    int totalBlocks = paradoxMachineBE.testRestoreBlocks().size();
                    int totalEntities = paradoxMachineBE.getEntitiesFromNBT().size();
                    int totalCostEnergy = paradoxMachineBE.getEnergyCost(totalBlocks, totalEntities);
                    if (ParadoxMachineScreen.hasShiftDown()) {
                        pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.formatted(this.container.getEnergy()), MagicHelpers.formatted(poweredMachineBE.getMaxEnergy())}), Component.translatable((String)"justdirethings.screen.paradoxenergycost", (Object[])new Object[]{MagicHelpers.formatted(totalCostEnergy)}))), pX, pY);
                    } else {
                        pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.energy", (Object[])new Object[]{MagicHelpers.withSuffix(this.container.getEnergy()), MagicHelpers.withSuffix(poweredMachineBE.getMaxEnergy())}), Component.translatable((String)"justdirethings.screen.paradoxenergycost", (Object[])new Object[]{MagicHelpers.withSuffix(totalCostEnergy)}))), pX, pY);
                    }
                }
            }
        }
    }

    @Override
    public void fluidBarTooltip(GuiGraphics pGuiGraphics, int pX, int pY) {
        BaseMachineBE baseMachineBE = this.baseMachineBE;
        if (baseMachineBE instanceof ParadoxMachineBE) {
            ParadoxMachineBE paradoxMachineBE = (ParadoxMachineBE)baseMachineBE;
            baseMachineBE = this.baseMachineBE;
            if (baseMachineBE instanceof FluidMachineBE) {
                FluidMachineBE fluidMachineBE = (FluidMachineBE)((Object)baseMachineBE);
                if (MiscTools.inBounds(this.topSectionLeft + this.getFluidBarOffset(), this.topSectionTop + 5, 18, 72, pX, pY)) {
                    int totalBlocks = paradoxMachineBE.testRestoreBlocks().size();
                    int totalEntities = paradoxMachineBE.getEntitiesFromNBT().size();
                    int totalCostFluid = paradoxMachineBE.getFluidCost(totalBlocks, totalEntities);
                    if (ParadoxMachineScreen.hasShiftDown()) {
                        pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.fluid", (Object[])new Object[]{this.container.getFluidStack().getHoverName(), MagicHelpers.formatted(this.container.getFluidAmount()), MagicHelpers.formatted(fluidMachineBE.getMaxMB())}), Component.translatable((String)"justdirethings.screen.paradoxfluidcost", (Object[])new Object[]{MagicHelpers.formatted(totalCostFluid)}))), pX, pY);
                    } else {
                        pGuiGraphics.renderTooltip(this.font, Language.getInstance().getVisualOrder(Arrays.asList(Component.translatable((String)"justdirethings.screen.fluid", (Object[])new Object[]{this.container.getFluidStack().getHoverName(), MagicHelpers.withSuffix(this.container.getFluidAmount()), MagicHelpers.withSuffix(fluidMachineBE.getMaxMB())}), Component.translatable((String)"justdirethings.screen.paradoxfluidcost", (Object[])new Object[]{MagicHelpers.withSuffix(totalCostFluid)}))), pX, pY);
                    }
                }
            }
        }
    }
}

