/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.setup.Registration;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.slf4j.Logger;

public class JustDireAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(JustDireAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(JustDireAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(JustDireAreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    private PotionContents potionContents = PotionContents.EMPTY;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public JustDireAreaEffectCloud(EntityType<? extends JustDireAreaEffectCloud> entityType, Level level) {
        super(entityType, level);
        this.noPhysics = true;
    }

    public JustDireAreaEffectCloud(Level level, double x, double y, double z) {
        this((EntityType<? extends JustDireAreaEffectCloud>)((EntityType)Registration.JustDireAreaEffectCloud.get()), level);
        this.setPos(x, y, z);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326332_) {
        p_326332_.define(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        p_326332_.define(DATA_WAITING, (Object)false);
        p_326332_.define(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1));
    }

    public void setRadius(float radius) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, (Object)Float.valueOf(Mth.clamp((float)radius, (float)0.0f, (float)32.0f)));
        }
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.getEntityData().get(DATA_RADIUS)).floatValue();
    }

    public void setPotionContents(PotionContents p_330869_) {
        this.potionContents = p_330869_;
        this.updateColor();
    }

    private void updateColor() {
        ParticleOptions particleoptions = (ParticleOptions)this.entityData.get(DATA_PARTICLE);
        if (particleoptions instanceof ColorParticleOption) {
            ColorParticleOption colorparticleoption = (ColorParticleOption)particleoptions;
            int i = this.potionContents.equals((Object)PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, (Object)ColorParticleOption.create((ParticleType)colorparticleoption.getType(), (int)FastColor.ARGB32.opaque((int)i)));
        }
    }

    public void addEffect(MobEffectInstance effectInstance) {
        this.setPotionContents(this.potionContents.withEffectAdded(effectInstance));
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions particleOption) {
        this.getEntityData().set(DATA_PARTICLE, (Object)particleOption);
    }

    protected void setWaiting(boolean waiting) {
        this.getEntityData().set(DATA_WAITING, (Object)waiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void tick() {
        block21: {
            float f;
            block22: {
                boolean flag1;
                boolean flag;
                block20: {
                    float f1;
                    int i;
                    super.tick();
                    flag = this.isWaiting();
                    f = this.getRadius();
                    if (!this.level().isClientSide) break block20;
                    if (flag && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleOptions particleoptions = this.getParticle();
                    if (flag) {
                        i = 2;
                        f1 = 0.2f;
                    } else {
                        i = Mth.ceil((float)((float)Math.PI * f * f));
                        f1 = f;
                    }
                    for (int j = 0; j < i; ++j) {
                        float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                        float f3 = Mth.sqrt((float)this.random.nextFloat()) * f1;
                        double d0 = this.getX() + (double)(Mth.cos((float)f2) * f3);
                        double d2 = this.getY();
                        double d4 = this.getZ() + (double)(Mth.sin((float)f2) * f3);
                        if (particleoptions.getType() == ParticleTypes.ENTITY_EFFECT) {
                            if (flag && this.random.nextBoolean()) {
                                this.level().addAlwaysVisibleParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)-1), d0, d2, d4, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.level().addAlwaysVisibleParticle(particleoptions, d0, d2, d4, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (flag) {
                            this.level().addAlwaysVisibleParticle(particleoptions, d0, d2, d4, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.level().addAlwaysVisibleParticle(particleoptions, d0, d2, d4, (0.5 - this.random.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.random.nextDouble()) * 0.15);
                    }
                    break block21;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard();
                    return;
                }
                boolean bl = flag1 = this.tickCount < this.waitTime;
                if (flag != flag1) {
                    this.setWaiting(flag1);
                }
                if (flag1) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((f += this.radiusPerTick) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.tickCount % 5 != 0) break block21;
                this.victims.entrySet().removeIf(p_287380_ -> this.tickCount >= (Integer)p_287380_.getValue());
                if (this.potionContents.hasEffects()) break block22;
                this.victims.clear();
                break block21;
            }
            ArrayList list = Lists.newArrayList();
            if (this.potionContents.potion().isPresent()) {
                for (MobEffectInstance mobeffectinstance1 : ((Potion)((Holder)this.potionContents.potion().get()).value()).getEffects()) {
                    list.add(new MobEffectInstance(mobeffectinstance1.getEffect(), mobeffectinstance1.mapDuration(p_267926_ -> p_267926_ / 4), mobeffectinstance1.getAmplifier(), mobeffectinstance1.isAmbient(), mobeffectinstance1.isVisible()));
                }
            }
            list.addAll(this.potionContents.customEffects());
            List list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            if (list1.isEmpty()) break block21;
            for (LivingEntity livingentity : list1) {
                double d1;
                double d5;
                double d3;
                if (this.victims.containsKey(livingentity) || !livingentity.isAffectedByPotions()) continue;
                if (list.stream().noneMatch(arg_0 -> ((LivingEntity)livingentity).canBeAffected(arg_0)) || !((d3 = (d5 = livingentity.getX() - this.getX()) * d5 + (d1 = livingentity.getZ() - this.getZ()) * d1) <= (double)(f * f))) continue;
                this.victims.put((Entity)livingentity, this.tickCount + this.reapplicationDelay);
                boolean affectedAnything = false;
                for (MobEffectInstance mobeffectinstance : list) {
                    if (((MobEffect)mobeffectinstance.getEffect().value()).getCategory() == MobEffectCategory.HARMFUL && this.getOwner() != null && livingentity.is((Entity)this.getOwner()) || ((MobEffect)mobeffectinstance.getEffect().value()).getCategory() == MobEffectCategory.BENEFICIAL && this.getOwner() != null && !livingentity.is((Entity)this.getOwner())) continue;
                    if (((MobEffect)mobeffectinstance.getEffect().value()).isInstantenous()) {
                        ((MobEffect)mobeffectinstance.getEffect().value()).applyInstantenousEffect((Entity)this, (Entity)this.getOwner(), livingentity, mobeffectinstance.getAmplifier(), 0.5);
                    } else {
                        livingentity.addEffect(new MobEffectInstance(mobeffectinstance), (Entity)this);
                    }
                    affectedAnything = true;
                }
                if (this.radiusOnUse != 0.0f && affectedAnything) {
                    if ((f += this.radiusOnUse) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.discard();
                return;
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float radiusOnUse) {
        this.radiusOnUse = radiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int durationOnUse) {
        this.durationOnUse = durationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUUID = owner == null ? null : owner.getUUID();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.tickCount = compound.getInt("Age");
        this.duration = compound.getInt("Duration");
        this.waitTime = compound.getInt("WaitTime");
        this.reapplicationDelay = compound.getInt("ReapplicationDelay");
        this.durationOnUse = compound.getInt("DurationOnUse");
        this.radiusOnUse = compound.getFloat("RadiusOnUse");
        this.radiusPerTick = compound.getFloat("RadiusPerTick");
        this.setRadius(compound.getFloat("Radius"));
        if (compound.hasUUID("Owner")) {
            this.ownerUUID = compound.getUUID("Owner");
        }
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (compound.contains("Particle", 10)) {
            ParticleTypes.CODEC.parse((DynamicOps)registryops, (Object)compound.get("Particle")).resultOrPartial(p_329991_ -> LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", p_329991_)).ifPresent(this::setParticle);
        }
        if (compound.contains("potion_contents")) {
            PotionContents.CODEC.parse((DynamicOps)registryops, (Object)compound.get("potion_contents")).resultOrPartial(p_340707_ -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", p_340707_)).ifPresent(this::setPotionContents);
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Age", this.tickCount);
        compound.putInt("Duration", this.duration);
        compound.putInt("WaitTime", this.waitTime);
        compound.putInt("ReapplicationDelay", this.reapplicationDelay);
        compound.putInt("DurationOnUse", this.durationOnUse);
        compound.putFloat("RadiusOnUse", this.radiusOnUse);
        compound.putFloat("RadiusPerTick", this.radiusPerTick);
        compound.putFloat("Radius", this.getRadius());
        RegistryOps registryops = this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        compound.put("Particle", (Tag)ParticleTypes.CODEC.encodeStart((DynamicOps)registryops, (Object)this.getParticle()).getOrThrow());
        if (this.ownerUUID != null) {
            compound.putUUID("Owner", this.ownerUUID);
        }
        if (!this.potionContents.equals((Object)PotionContents.EMPTY)) {
            Tag tag = (Tag)PotionContents.CODEC.encodeStart((DynamicOps)registryops, (Object)this.potionContents).getOrThrow();
            compound.put("potion_contents", tag);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (DATA_RADIUS.equals(key)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(key);
    }

    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions getDimensions(Pose pose) {
        return EntityDimensions.scalable((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

