/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.justdirethings.common.entities;

import com.direwolf20.justdirethings.client.particles.paradoxparticle.ParadoxParticleData;
import com.direwolf20.justdirethings.datagen.JustDireBlockTags;
import com.direwolf20.justdirethings.datagen.JustDireEntityTags;
import com.direwolf20.justdirethings.datagen.JustDireItemTags;
import com.direwolf20.justdirethings.setup.Registration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.entity.PartEntity;

public class ParadoxEntity
extends Entity {
    private static final EntityDataAccessor<Integer> REQUIRED_CONSUMPTION = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CONSUMPTION = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Float> SHRINK_SCALE = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> TARGET_RADIUS = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> GROWTH_TICKS = SynchedEntityData.defineId(ParadoxEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public int growthDuration = 50;
    private final Map<BlockPos, Integer> blocksToAbsorb = new HashMap<BlockPos, Integer>();
    private int maxRadius = 12;
    private double itemSuckSpeed = 0.5;
    private boolean collapsing = false;
    private int maxBlocksForPerf = 40;
    public int radiusGrowthTime = 1200;
    public int radiusGrowthTimer = 0;
    public int maxRadiusGrowthTimer = this.radiusGrowthTime * this.maxRadius + this.radiusGrowthTime;
    public int growthPerBlock = 10;
    public int growthPerItem = 10;

    public ParadoxEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    public ParadoxEntity(Level level, BlockPos blockPos) {
        this((EntityType<? extends Entity>)((EntityType)Registration.ParadoxEntity.get()), level);
        this.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
    }

    public void tick() {
        super.tick();
        int currentRadius = this.getRadius();
        int targetRadius = this.getTargetRadius();
        this.incRadiusGrowthTimer(1);
        if (!this.level().isClientSide) {
            int calculatedTargetRadius;
            if (this.collapsing) {
                float scale = this.getShrinkScale() - 0.02f;
                this.setShrinkScale(Math.max(scale, 0.0f));
                if (this.getShrinkScale() <= 0.01f) {
                    this.discard();
                }
                return;
            }
            if (this.tickCount == 1 || this.tickCount % 600 == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), Registration.PARADOX_AMBIENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if ((calculatedTargetRadius = Math.min(this.maxRadius, Math.max(0, this.radiusGrowthTimer / this.radiusGrowthTime))) != targetRadius && this.getGrowthTicks() == 0) {
                this.setTargetRadius(calculatedTargetRadius);
            }
            if (currentRadius != this.getTargetRadius()) {
                int growthTicks = this.getGrowthTicks();
                this.setGrowthTicks(++growthTicks);
                if (growthTicks >= this.growthDuration) {
                    this.setRadius(targetRadius);
                    this.setGrowthTicks(0);
                }
            }
            this.handleBlockAbsorption(currentRadius);
            this.handleItemAbsorption(currentRadius);
        } else if (this.getShrinkScale() < 1.0f) {
            Minecraft.getInstance().getSoundManager().stop(Registration.PARADOX_AMBIENT.get().getLocation(), SoundSource.HOSTILE);
        }
    }

    public void incRadiusGrowthTimer(int value) {
        this.radiusGrowthTimer = Math.min(this.maxRadiusGrowthTimer, this.radiusGrowthTimer + value);
    }

    public void decRadiusGrowthTimer(int value) {
        this.radiusGrowthTimer = Math.max(0, this.radiusGrowthTimer - value);
    }

    private void handleBlockAbsorption(int currentRadius) {
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)this.getOnPos().offset(-currentRadius, -currentRadius, -currentRadius), (BlockPos)this.getOnPos().offset(currentRadius, currentRadius, currentRadius))) {
            float rand = this.random.nextFloat();
            if (!this.isBlockValid(pos) || !(rand < 0.0125f)) continue;
            this.blocksToAbsorb.put(new BlockPos((Vec3i)pos), 40 + this.random.nextInt(41));
        }
        Iterator<Map.Entry<BlockPos, Integer>> iterator = this.blocksToAbsorb.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockPos, Integer> entry = iterator.next();
            BlockPos pos = entry.getKey();
            if (!this.isBlockWithinRadius(pos) || this.level().isEmptyBlock(pos)) {
                iterator.remove();
                continue;
            }
            int timeLeft = entry.getValue() - 1;
            Vec3 targetVec = this.position().add(0.0, 0.5, 0.0);
            ItemStack blockStack = new ItemStack((ItemLike)this.level().getBlockState(pos).getBlock());
            if (blockStack.equals(ItemStack.EMPTY) || blockStack.getItem().equals(Items.AIR)) {
                blockStack = new ItemStack((ItemLike)Items.STONE);
            }
            ParadoxParticleData data = new ParadoxParticleData(blockStack, targetVec.x, targetVec.y, targetVec.z, 1, this.getUUID());
            Vec3 sourcePos = pos.getCenter();
            double x = sourcePos.x + (this.random.nextDouble() - 0.5);
            double y = sourcePos.y + (this.random.nextDouble() - 0.5);
            double z = sourcePos.z + (this.random.nextDouble() - 0.5);
            float spawnChance = 1.0f;
            if (this.blocksToAbsorb.size() > this.maxBlocksForPerf * 2) {
                spawnChance = 0.25f;
            } else if (this.blocksToAbsorb.size() > this.maxBlocksForPerf) {
                spawnChance = 0.5f;
            }
            if (this.random.nextFloat() < spawnChance) {
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)data, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
            if (timeLeft <= 0) {
                int particles = 50;
                if (this.blocksToAbsorb.size() > this.maxBlocksForPerf * 2) {
                    particles = 10;
                } else if (this.blocksToAbsorb.size() > this.maxBlocksForPerf) {
                    particles = 20;
                }
                for (int i = 0; i < particles; ++i) {
                    x = sourcePos.x + (this.random.nextDouble() - 0.5);
                    y = sourcePos.y + (this.random.nextDouble() - 0.5);
                    z = sourcePos.z + (this.random.nextDouble() - 0.5);
                    ((ServerLevel)this.level()).sendParticles((ParticleOptions)data, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
                }
                this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.incRadiusGrowthTimer(this.growthPerBlock);
                iterator.remove();
                continue;
            }
            entry.setValue(timeLeft);
        }
    }

    public boolean isBlockWithinRadius(BlockPos pos) {
        BlockPos centerPos = this.getOnPos();
        int radius = this.getTargetRadius();
        AABB aabb = new AABB((double)(centerPos.getX() - radius), (double)(centerPos.getY() - radius), (double)(centerPos.getZ() - radius), (double)(centerPos.getX() + radius + 1), (double)(centerPos.getY() + radius + 1), (double)(centerPos.getZ() + radius + 1));
        return aabb.contains((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    private void handleItemsPostShrink(int targetRadius) {
        List items = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)((float)this.getRadius() + 0.25f)));
        List newItems = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)((float)targetRadius + 0.25f)));
        for (ItemEntity item : items) {
            if (newItems.contains(item)) continue;
            item.setNoGravity(false);
        }
        List livingEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)((float)this.getRadius() + 0.25f)));
        List newLivingEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)((float)targetRadius + 0.25f)));
        for (LivingEntity livingEntity : livingEntities) {
            if (newLivingEntities.contains(livingEntity)) continue;
            livingEntity.setNoGravity(false);
        }
    }

    private boolean isValidItem(ItemEntity entity) {
        ItemStack itemStack = entity.getItem();
        return !itemStack.is(JustDireItemTags.PARADOX_DENY);
    }

    private boolean isValidEntity(Entity entity) {
        if (entity.isMultipartEntity()) {
            return false;
        }
        if (entity instanceof PartEntity) {
            return false;
        }
        if (entity instanceof Player) {
            return false;
        }
        if (entity.getType().is(JustDireEntityTags.PARADOX_ABSORB_DENY)) {
            return false;
        }
        return !entity.getType().is(Tags.EntityTypes.TELEPORTING_NOT_SUPPORTED);
    }

    private void handleItemAbsorption(int currentRadius) {
        List items = this.level().getEntitiesOfClass(ItemEntity.class, this.getBoundingBox().inflate((double)((float)currentRadius + 0.25f)));
        for (ItemEntity item : items) {
            if (!this.isValidItem(item)) continue;
            if (this.collapsing) break;
            Vec3 itemPosition = item.position();
            Vec3 direction = this.position().subtract(itemPosition).normalize().scale(this.itemSuckSpeed);
            item.setNoGravity(true);
            item.setDeltaMovement(direction);
            if (!this.position().closerThan((Position)item.position(), 0.25)) continue;
            ItemStack itemStack = item.getItem();
            if (itemStack.is((Item)Registration.TimeCrystal.get())) {
                this.collapse();
            } else {
                this.incRadiusGrowthTimer(this.growthPerItem * itemStack.getCount());
            }
            item.discard();
        }
        if (this.collapsing) {
            return;
        }
        List livingEntities = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate((double)((float)currentRadius + 0.25f)));
        for (LivingEntity livingEntity : livingEntities) {
            if (!this.isValidEntity((Entity)livingEntity)) continue;
            Vec3 position = livingEntity.position();
            Vec3 direction = this.position().subtract(position).normalize().scale(this.itemSuckSpeed);
            livingEntity.setNoGravity(true);
            livingEntity.setDeltaMovement(direction);
            if (!this.position().closerThan((Position)livingEntity.position(), 0.25)) continue;
            livingEntity.discard();
        }
    }

    private void collapse() {
        this.collapsing = true;
        this.handleItemsPostShrink(0);
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.WITHER_AMBIENT, SoundSource.HOSTILE, 1.0f, 0.25f);
    }

    public boolean isBlockValid(BlockPos blockPos) {
        BlockState blockState = this.level().getBlockState(blockPos);
        if (blockState.isAir()) {
            return false;
        }
        if (blockState.is(JustDireBlockTags.PARADOX_ABSORB_DENY)) {
            return false;
        }
        if (this.blocksToAbsorb.containsKey(blockPos)) {
            return false;
        }
        if (blockState.getDestroySpeed((BlockGetter)this.level(), blockPos) < 0.0f) {
            return false;
        }
        Block block = blockState.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return blockState.getFluidState().isSource();
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(REQUIRED_CONSUMPTION, (Object)100);
        builder.define(CONSUMPTION, (Object)0);
        builder.define(RADIUS, (Object)0);
        builder.define(SHRINK_SCALE, (Object)Float.valueOf(1.0f));
        builder.define(TARGET_RADIUS, (Object)0);
        builder.define(GROWTH_TICKS, (Object)0);
    }

    public int getRadius() {
        return (Integer)this.entityData.get(RADIUS);
    }

    public void setRadius(int radius) {
        this.entityData.set(RADIUS, (Object)Math.min(radius, this.maxRadius));
    }

    public int getGrowthTicks() {
        return (Integer)this.entityData.get(GROWTH_TICKS);
    }

    public void setGrowthTicks(int growthTicks) {
        this.entityData.set(GROWTH_TICKS, (Object)growthTicks);
    }

    public int getTargetRadius() {
        return (Integer)this.entityData.get(TARGET_RADIUS);
    }

    public void setTargetRadius(int radius) {
        this.entityData.set(TARGET_RADIUS, (Object)radius);
        this.setGrowthTicks(0);
    }

    public float getShrinkScale() {
        return ((Float)this.entityData.get(SHRINK_SCALE)).floatValue();
    }

    public void setShrinkScale(float scale) {
        this.entityData.set(SHRINK_SCALE, (Object)Float.valueOf(scale));
    }

    public int getRequiredConsumption() {
        return (Integer)this.entityData.get(REQUIRED_CONSUMPTION);
    }

    public int getConsumed() {
        return (Integer)this.entityData.get(CONSUMPTION);
    }

    public void setRequiredConsumption(int totalRequired) {
        this.entityData.set(REQUIRED_CONSUMPTION, (Object)totalRequired);
    }

    public void setConsumption(int consumed) {
        this.entityData.set(CONSUMPTION, (Object)consumed);
    }

    public void consume(int amt) {
        this.entityData.set(CONSUMPTION, (Object)(this.getConsumed() + amt));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("requiredConsumption")) {
            this.entityData.set(REQUIRED_CONSUMPTION, (Object)compound.getInt("requiredConsumption"));
        }
        if (compound.contains("consumed")) {
            this.entityData.set(CONSUMPTION, (Object)compound.getInt("consumed"));
        }
        if (compound.contains("radius")) {
            this.entityData.set(RADIUS, (Object)compound.getInt("radius"));
        }
        if (compound.contains("targetRadius")) {
            this.entityData.set(TARGET_RADIUS, (Object)compound.getInt("targetRadius"));
        }
        if (compound.contains("radiusGrowthTimer")) {
            this.radiusGrowthTimer = compound.getInt("radiusGrowthTimer");
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("requiredConsumption", this.getRequiredConsumption());
        compound.putInt("consumed", this.getConsumed());
        compound.putInt("radius", this.getRadius());
        compound.putInt("targetRadius", this.getTargetRadius());
        compound.putInt("radiusGrowthTimer", this.radiusGrowthTimer);
    }
}

