/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.block_models;

import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.BlackboardTextureManager;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BlackboardBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.components.BlackboardData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class BlackboardBakedModel
implements CustomBakedModel {
    private final ModelState modelTransform;
    private final BakedModel back;

    public BlackboardBakedModel(BakedModel back, ModelState modelTransform) {
        this.back = back;
        this.modelTransform = modelTransform;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        return this.back.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.back.getQuads(state, side, rand));
        if (data != ExtraModelData.EMPTY && state != null && side == null) {
            Direction dir = (Direction)state.getValue((Property)BlackboardBlock.FACING);
            BlackboardData key = (BlackboardData)data.get(BlackboardBlockTile.BLACKBOARD_KEY);
            if (key != null) {
                BlackboardTextureManager.BlackboardVisuals blackboard = BlackboardTextureManager.getInstance(key);
                quads.addAll(blackboard.getOrCreateModel(dir, this::generateQuads));
            }
        }
        return quads;
    }

    private List<BakedQuad> generateQuads(BlackboardTextureManager.BlackboardVisuals blackboard, Direction dir) {
        byte[][] pixels = blackboard.getPixels();
        boolean emissive = blackboard.isGlow();
        TextureAtlasSprite black = ModMaterials.BLACKBOARD_BLACK.sprite();
        TextureAtlasSprite white = ModMaterials.BLACKBOARD_WHITE.sprite();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Transformation rotation = this.modelTransform.getRotation();
        for (int x = 0; x < pixels.length; ++x) {
            int length = 0;
            int startY = 0;
            byte prevColor = pixels[0][x];
            for (int y = 0; y <= pixels[x].length; ++y) {
                Byte current = null;
                if (y < pixels[x].length) {
                    byte b = pixels[x][y];
                    if (prevColor == b) {
                        ++length;
                        continue;
                    }
                    current = b;
                }
                int tint = 0xFF000000 | BlackboardBlock.colorFromByte(prevColor);
                TextureAtlasSprite sprite = prevColor == 0 ? black : white;
                quads.add(BlackboardBakedModel.createPixelQuad((float)(15 - x) / 16.0f, (float)(16 - length - startY) / 16.0f, 0.0625f, (float)length / 16.0f, sprite, tint, rotation, prevColor != 0 && emissive));
                startY = y;
                if (current != null) {
                    prevColor = current;
                }
                length = 1;
            }
        }
        return quads;
    }

    public static BakedQuad createPixelQuad(float x, float y, float width, float height, TextureAtlasSprite sprite, int color, Transformation transform, boolean emissive) {
        float u0 = 1.0f - x;
        float v0 = 1.0f - y;
        float u1 = 1.0f - (x + width);
        float v1 = 1.0f - (y + height);
        AtomicReference quad = new AtomicReference();
        try (BakedQuadBuilder builder = BakedQuadBuilder.create((TextureAtlasSprite)sprite, (Transformation)transform, quad::set);){
            builder.setAutoDirection();
            BlackboardBakedModel.putVertex(builder, x + width, y + height, u1, v1, color);
            BlackboardBakedModel.putVertex(builder, x + width, y, u1, v0, color);
            BlackboardBakedModel.putVertex(builder, x, y, u0, v0, color);
            BlackboardBakedModel.putVertex(builder, x, y + height, u0, v1, color);
            if (emissive) {
                builder.lightEmission(15);
            }
        }
        catch (Exception e) {
            Supplementaries.error();
        }
        return (BakedQuad)quad.get();
    }

    private static void putVertex(BakedQuadBuilder builder, float x, float y, float u, float v, int color) {
        Vector3f posV = new Vector3f(x, y, 0.6875f);
        posV.set((float)Math.round(posV.x() * 16.0f) / 16.0f, (float)Math.round(posV.y() * 16.0f) / 16.0f, (float)Math.round(posV.z() * 16.0f) / 16.0f);
        builder.addVertex(posV.x, posV.y, posV.z);
        builder.setColor(color);
        builder.setUv(u / 16.0f, v / 16.0f);
        builder.setNormal(0.0f, 0.0f, -1.0f);
    }
}

