/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.hud;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.client.hud.neoforge.SelectableContainerItemHudImpl;
import net.mehvahdjukaar.supplementaries.common.items.SelectableContainerItem;
import net.mehvahdjukaar.supplementaries.common.items.components.SelectableContainerContent;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundCycleSelectableContainerItemPacket;
import net.mehvahdjukaar.supplementaries.common.utils.IQuiverPlayer;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ClientRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectableContainerItemHud
implements LayeredDraw.Layer {
    protected final Minecraft mc;
    @Nullable
    private SelectableContainerItem<?, ?> itemUsed;
    private SlotReference stackSlot;
    private boolean usingKey = false;
    private double lastCumulativeMouseDx = 0.0;

    public static SelectableContainerItemHud getInstance() {
        return Holder.INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static SelectableContainerItemHud makeInstance() {
        return SelectableContainerItemHudImpl.makeInstance();
    }

    protected SelectableContainerItemHud(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public boolean isActive() {
        return this.itemUsed != null;
    }

    public boolean isUsingKey() {
        return this.itemUsed != null && this.usingKey;
    }

    public boolean isUsingItem() {
        return this.itemUsed != null && !this.usingKey;
    }

    public void setUsingItem(SlotReference slot, LivingEntity player) {
        SelectableContainerItem selectable;
        this.stackSlot = slot;
        Item item = slot.getItem(player);
        this.itemUsed = item instanceof SelectableContainerItem ? (selectable = (SelectableContainerItem)item) : null;
    }

    public void setUsingKeybind(SlotReference slot, Player player) {
        this.setUsingItem(slot, (LivingEntity)player);
        this.usingKey = this.itemUsed != null;
    }

    private void closeHud() {
        this.itemUsed = null;
        this.usingKey = false;
        this.stackSlot = SlotReference.EMPTY;
    }

    public boolean onMouseScrolled(double scrollDelta) {
        if (this.itemUsed != null) {
            int amount = scrollDelta > 0.0 ? -1 : 1;
            this.sendCycle(amount);
            return true;
        }
        return false;
    }

    public void ohMouseMoved(double deltaX) {
        if (this.itemUsed != null && ClientConfigs.Items.QUIVER_MOUSE_MOVEMENT.get().booleanValue()) {
            LocalPlayer player;
            double scale = (Double)this.mc.options.sensitivity().get() * 0.02;
            int oldI = (int)(this.lastCumulativeMouseDx * scale);
            this.lastCumulativeMouseDx += deltaX;
            int slotsMoved = (int)(this.lastCumulativeMouseDx * scale) - oldI;
            if (slotsMoved != 0 && (player = this.mc.player) != null) {
                this.sendCycle(slotsMoved);
            }
        }
    }

    private void sendCycle(int slotsMoved) {
        ItemStack stack = this.getItemUsed();
        if (!stack.isEmpty() && this.itemUsed != null) {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundCycleSelectableContainerItemPacket(slotsMoved, this.stackSlot));
            this.itemUsed.modify(stack, m -> {
                m.cycle(slotsMoved);
                return true;
            });
        }
    }

    private void sendSetSlot(int number) {
        ItemStack stack = this.getItemUsed();
        if (!stack.isEmpty() && this.itemUsed != null) {
            NetworkHelper.sendToServer((CustomPacketPayload)new ServerBoundCycleSelectableContainerItemPacket(number, this.stackSlot, true));
            this.itemUsed.modify(stack, m -> {
                m.setSelectedSlot(number);
                return true;
            });
        }
    }

    public boolean onKeyPressed(int key, int action, int modifiers) {
        if (this.itemUsed == null) {
            return false;
        }
        if (action != 1) {
            return false;
        }
        switch (key) {
            case 263: {
                this.sendCycle(-1);
                return true;
            }
            case 262: {
                this.sendCycle(1);
                return true;
            }
        }
        int number = key - 48;
        if (number >= 1 && number <= 9) {
            if (number <= this.itemUsed.getMaxSlots()) {
                this.sendSetSlot(number - 1);
            }
            return true;
        }
        return false;
    }

    @NotNull
    private ItemStack getItemUsed() {
        LocalPlayer player = this.mc.player;
        if (this.itemUsed == null) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.stackSlot.get((LivingEntity)player);
        if (!stack.is(this.itemUsed)) {
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public void render(GuiGraphics graphics, DeltaTracker arg2) {
        Item item;
        boolean keyDown;
        if (this.itemUsed == null) {
            return;
        }
        if (!(this.mc.getCameraEntity() instanceof IQuiverPlayer)) {
            this.closeHud();
            return;
        }
        if (this.isUsingKey() && !ClientRegistry.QUIVER_KEYBIND.isUnbound() && !(keyDown = InputConstants.isKeyDown((long)this.mc.getWindow().getWindow(), (int)ClientRegistry.QUIVER_KEYBIND.key.getValue()))) {
            this.closeHud();
            return;
        }
        ItemStack stack = this.getItemUsed();
        if (stack.isEmpty() || !((item = stack.getItem()) instanceof SelectableContainerItem)) {
            this.closeHud();
            return;
        }
        SelectableContainerItem sc = (SelectableContainerItem)item;
        SelectableContainerContent data = (SelectableContainerContent)stack.get(sc.getComponentType());
        if (data == null) {
            this.closeHud();
            return;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        int selected = data.getSelectedSlot();
        List<ItemStack> items = data.getContentUnsafe();
        int slots = items.size();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int centerX = graphics.guiWidth() / 2;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, -90.0f);
        int uWidth = slots * 20 + 2;
        int px = uWidth / 2;
        int py = graphics.guiHeight() / 2 - 40;
        graphics.blitSprite(ModTextures.SELECTABLE_ITEM_BAR, 182, 22, 0, 0, centerX - (px += ClientConfigs.Items.QUIVER_GUI_X.get().intValue()), py += ClientConfigs.Items.QUIVER_GUI_Y.get().intValue(), uWidth - 1, 22);
        graphics.blitSprite(ModTextures.SELECTABLE_ITEM_BAR, 182, 22, 181, 0, centerX + px - 1, py, 1, 22);
        graphics.blitSprite(ModTextures.SELECTABLE_ITEM_OVERLAY, centerX - px - 1 + selected * 20, py - 1, 24, 24);
        poseStack.popPose();
        int i1 = 1;
        for (int i = 0; i < slots; ++i) {
            int kx = centerX - px + 3 + i * 20;
            this.renderSlot(graphics, kx, py + 3, items.get(i), i1++, this.mc.font);
        }
        RenderSystem.disableBlend();
        ItemStack selectedArrow = items.get(selected);
        if (!selectedArrow.isEmpty()) {
            this.drawHighlight(graphics, graphics.guiWidth(), py, selectedArrow);
        }
        poseStack.popPose();
    }

    private void renderSlot(GuiGraphics graphics, int pX, int pY, ItemStack pStack, int seed, Font font) {
        if (!pStack.isEmpty()) {
            graphics.renderItem(pStack, pX, pY, seed);
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            graphics.renderItemDecorations(font, pStack, pX, pY);
        }
    }

    protected abstract void drawHighlight(GuiGraphics var1, int var2, int var3, ItemStack var4);

    private static class Holder {
        private static final SelectableContainerItemHud INSTANCE = SelectableContainerItemHud.makeInstance();

        private Holder() {
        }
    }
}

