/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.JarBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FaucetBlockTile;
import net.mehvahdjukaar.supplementaries.common.utils.FluidsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FaucetBlock
extends WaterBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)15.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_EAST = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH, (Direction)Direction.EAST);
    protected static final VoxelShape SHAPE_NORTH_JAR = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH_JAR = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.SOUTH);
    protected static final VoxelShape SHAPE_WEST_JAR = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.WEST);
    protected static final VoxelShape SHAPE_EAST_JAR = MthUtils.rotateVoxelShape((VoxelShape)SHAPE_NORTH_JAR, (Direction)Direction.EAST);
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty ENABLED = BlockStateProperties.ENABLED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty HAS_WATER = ModBlockProperties.HAS_WATER;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL_0_7;
    public static final BooleanProperty CONNECTED = ModBlockProperties.CONNECTED;

    public FaucetBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(s -> (Integer)s.getValue((Property)LIGHT_LEVEL)));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> SHAPE_SOUTH_JAR;
                case Direction.EAST -> SHAPE_EAST_JAR;
                case Direction.WEST -> SHAPE_WEST_JAR;
                default -> SHAPE_NORTH_JAR;
            };
        }
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean enabled = (Boolean)state.getValue((Property)ENABLED);
        float f = enabled ? 1.0f : 1.2f;
        level.playSound(null, pos, ModSounds.FAUCET.get(), SoundSource.BLOCKS, 1.0f, f);
        level.gameEvent((Entity)player, (Holder)(enabled ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE), pos);
        this.updateBlock(state, level, pos, true);
        return InteractionResult.SUCCESS;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        boolean hasWater = this.updateTileFluid(state, pos, (LevelAccessor)worldIn);
        if (hasWater != (Boolean)state.getValue((Property)HAS_WATER)) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            boolean canConnectDown = this.canConnect(facingState, worldIn, facingPos, facing.getOpposite());
            return (BlockState)stateIn.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(canConnectDown));
        }
        if (facing == ((Direction)stateIn.getValue((Property)FACING)).getOpposite()) {
            boolean hasWater = this.updateTileFluid(stateIn, currentPos, worldIn);
            return (BlockState)stateIn.setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater));
        }
        return stateIn;
    }

    public boolean updateTileFluid(BlockState state, BlockPos pos, LevelAccessor world) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)blockEntity;
            if (world instanceof Level) {
                Level level = (Level)world;
                return tile.updateContainedFluidVisuals(level, pos, state);
            }
        }
        return false;
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile tile = (FaucetBlockTile)blockEntity;
            if (world instanceof Level) {
                Level level = (Level)world;
                boolean water = tile.updateContainedFluidVisuals(level, pos, state);
                if ((Boolean)state.getValue((Property)HAS_WATER) != water) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(water)), 2);
                }
            }
        }
    }

    private boolean canConnect(BlockState downState, LevelAccessor world, BlockPos pos, Direction dir) {
        Level level;
        if (downState.getBlock() instanceof JarBlock) {
            return true;
        }
        if (downState.getBlock() instanceof AbstractCauldronBlock) {
            return false;
        }
        if (downState.is(ModTags.FAUCET_CONNECTION_BLACKLIST)) {
            return false;
        }
        if (downState.is(ModTags.FAUCET_CONNECTION_WHITELIST)) {
            return false;
        }
        if (downState.hasProperty((Property)BlockStateProperties.LEVEL_HONEY)) {
            return true;
        }
        return world instanceof Level && FluidsUtil.hasFluidHandler(level = (Level)world, pos, dir);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(state, world, pos, neighborBlock, fromPos, moving);
        this.updateBlock(state, world, pos, false);
    }

    public void updateBlock(BlockState state, Level world, BlockPos pos, boolean toggle) {
        boolean hasWater;
        boolean isPowered = world.hasNeighborSignal(pos);
        if (isPowered != (Boolean)state.getValue((Property)POWERED) || toggle) {
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue((Property)ENABLED, (Comparable)Boolean.valueOf(toggle ^ (Boolean)state.getValue((Property)ENABLED))), 2);
        }
        if ((hasWater = this.updateTileFluid(state, pos, (LevelAccessor)world)) != (Boolean)state.getValue((Property)HAS_WATER)) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_WATER, (Comparable)Boolean.valueOf(hasWater)));
        }
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.POWERED) ^ (Boolean)state.getValue((Property)BlockStateProperties.ENABLED);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ENABLED, POWERED, HAS_WATER, CONNECTED, WATERLOGGED, LIGHT_LEVEL});
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction dir = context.getClickedFace().getAxis() == Direction.Axis.Y ? Direction.NORTH : context.getClickedFace();
        boolean water = world.getFluidState(pos).getType() == Fluids.WATER;
        boolean hasJar = this.canConnect(world.getBlockState(pos.below()), (LevelAccessor)world, pos.below(), Direction.UP);
        boolean powered = world.hasNeighborSignal(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(hasJar))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered));
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        boolean flag = this.isOpen(state);
        if (((Boolean)state.getValue((Property)HAS_WATER)).booleanValue() && !((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            double d = random.nextFloat();
            double d2 = flag ? 0.0 : 0.06;
            if (d > d2) {
                return;
            }
            float d3 = 0.125f;
            double x = (double)pos.getX() + 0.5 + (double)d3 * ((double)random.nextFloat() - 0.5);
            double y = (double)pos.getY() + 0.25;
            double z = (double)pos.getZ() + 0.5 + (double)d3 * ((double)random.nextFloat() - 0.5);
            int color = this.getTileParticleColor(pos, world);
            float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
            float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
            float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
            world.addParticle((ParticleOptions)ModParticles.DRIPPING_LIQUID.get(), x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public int getTileParticleColor(BlockPos pos, Level world) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FaucetBlockTile) {
            FaucetBlockTile te = (FaucetBlockTile)blockEntity;
            return te.tempFluidHolder.getCachedParticleColor((BlockAndTintGetter)world, pos);
        }
        return 4340983;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new FaucetBlockTile(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.FAUCET_TILE.get(), (BlockEntityTicker)(pLevel.isClientSide ? null : FaucetBlockTile::tick));
    }
}

