/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.EnumSet;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.ParticleUtil;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModParticles;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChangeOverTimeBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BellowsBlockTile
extends BlockEntity {
    private static final float MAX_COMPRESSION = 0.125f;
    private float height = 0.0f;
    private float prevHeight = 0.0f;
    private int manualPress = 0;
    private long startTime = 0L;
    private boolean isPressed = false;
    private boolean lastBlowing = false;

    public BellowsBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.BELLOWS_TILE.get(), pos, state);
    }

    public float getHeight(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.prevHeight, (float)this.height);
    }

    public void setManualPress() {
        this.manualPress = 10;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    private AABB getProgressDeltaAabb(Direction dir) {
        AABB bb = new AABB(BlockPos.ZERO);
        float max = Math.max(this.height, this.prevHeight);
        float min = Math.min(this.height, this.prevHeight);
        return (switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> bb.setMaxY((double)(1.0f + max)).setMinY((double)(1.0f + min));
            case Direction.DOWN -> bb.setMaxY((double)max).setMinY((double)min);
            case Direction.NORTH -> bb.setMaxZ((double)max).setMinZ((double)min);
            case Direction.SOUTH -> bb.setMaxZ((double)(1.0f + max)).setMinZ((double)(1.0f + min));
            case Direction.EAST -> bb.setMaxX((double)(1.0f + max)).setMinX((double)(1.0f + min));
            case Direction.WEST -> bb.setMaxX((double)max).setMinX((double)min);
        }).move(this.worldPosition);
    }

    private void moveCollidedEntities(Level level) {
        Direction dir = this.getDirection().getAxis() == Direction.Axis.Y ? Direction.SOUTH : Direction.UP;
        for (int j = 0; j < 2; ++j) {
            AABB progressDelta = this.getProgressDeltaAabb(dir);
            List list = level.getEntities(null, progressDelta);
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                    double f = 0.0;
                    entity.move(MoverType.SHULKER_BOX, new Vec3((progressDelta.getXsize() + f) * (double)dir.getStepX(), (progressDelta.getYsize() + f) * (double)dir.getStepY(), (progressDelta.getZsize() + f) * (double)dir.getStepZ()));
                    entity.setOnGround(true);
                }
            }
            dir = dir.getOpposite();
        }
    }

    private void pushEntities(Direction facing, float period, float range, Level level) {
        double velocity = CommonConfigs.Redstone.BELLOWS_BASE_VEL_SCALING.get() / (double)period;
        double maxVelocity = CommonConfigs.Redstone.BELLOWS_MAX_VEL.get();
        AABB facingBox = AABB.encapsulatingFullBlocks((BlockPos)this.worldPosition, (BlockPos)this.worldPosition.relative(facing, (int)range));
        List list = level.getEntitiesOfClass(Entity.class, facingBox);
        block7: for (Entity entity : list) {
            if (!this.inLineOfSight(entity, facing, level)) continue;
            if (facing == Direction.UP) {
                maxVelocity *= 0.5;
            }
            AABB entityBB = entity.getBoundingBox();
            velocity *= ((double)range - (switch (facing) {
                case Direction.NORTH -> {
                    double b = this.worldPosition.getZ();
                    if (entityBB.maxZ > b) continue block7;
                    yield b - entity.getZ();
                }
                case Direction.EAST -> {
                    double b = (double)this.worldPosition.getX() + 1.0;
                    if (entityBB.minX < b) continue block7;
                    yield entity.getX() - b;
                }
                case Direction.WEST -> {
                    double b = this.worldPosition.getX();
                    if (entityBB.maxX > b) continue block7;
                    yield b - entity.getX();
                }
                case Direction.UP -> {
                    double b = (double)this.worldPosition.getY() + 1.0;
                    if (entityBB.minY < b) continue block7;
                    yield entity.getY() - b;
                }
                case Direction.DOWN -> {
                    double b = this.worldPosition.getY();
                    if (entityBB.maxY > b) continue block7;
                    yield b - entity.getY();
                }
                default -> {
                    double b = (double)this.worldPosition.getZ() + 1.0;
                    if (entityBB.minZ < b) continue block7;
                    yield entity.getZ() - b;
                }
            })) / (double)range;
            if (!(Math.abs(entity.getDeltaMovement().get(facing.getAxis())) < maxVelocity)) continue;
            entity.push((double)facing.getStepX() * velocity, (double)facing.getStepY() * velocity, (double)facing.getStepZ() * velocity);
            entity.hurtMarked = true;
        }
    }

    private void blowParticles(float air, Direction facing, Level level, boolean waterInFront) {
        if (level.random.nextFloat() < air) {
            BlockPos facingPos;
            AirType type = AirType.BUBBLE;
            BlockPos frontPos = facingPos = this.worldPosition.relative(facing);
            boolean hasSponge = false;
            if (!waterInFront) {
                BlockState frontState = level.getBlockState(facingPos);
                if (frontState.getBlock() instanceof WetSpongeBlock) {
                    hasSponge = true;
                    frontPos = frontPos.relative(facing);
                }
                type = AirType.AIR;
            }
            if (!Block.canSupportCenter((LevelReader)level, (BlockPos)frontPos, (Direction)facing.getOpposite())) {
                BlockPos p = this.worldPosition;
                if (hasSponge) {
                    EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
                    directions.remove(facing.getOpposite());
                    directions.remove(facing);
                    for (Direction d : directions) {
                        if (!level.getBlockState(facingPos.relative(d)).is(ModRegistry.SOAP_BLOCK.get())) continue;
                        type = AirType.SOAP;
                        p = facingPos;
                        break;
                    }
                    if (type != AirType.SOAP) {
                        return;
                    }
                }
                this.spawnParticle(level, p, facing, type);
            }
        }
    }

    private <T extends BlockEntity> void tickFurnaces(BlockPos frontPos, BlockState frontState, Level level, T tile) {
        BlockEntityTicker ticker;
        if (tile != null && (ticker = frontState.getTicker(level, tile.getType())) != null) {
            ticker.tick(level, frontPos, frontState, tile);
        }
    }

    private void tickFurnaces(BlockPos pos, Level level) {
        BlockState state = level.getBlockState(pos);
        if (state.is(ModTags.BELLOWS_TICKABLE_TAG)) {
            BlockEntity te = level.getBlockEntity(pos);
            this.tickFurnaces(pos, state, level, te);
        } else if (state.getBlock() instanceof ChangeOverTimeBlock && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            state.randomTick(serverLevel, pos, level.random);
        }
    }

    private void refreshFire(int n, Direction facing, BlockPos frontPos, Level level) {
        for (int i = 0; i < n; ++i) {
            int age;
            BlockState fb = level.getBlockState(frontPos);
            if (fb.getBlock() instanceof FireBlock && (age = ((Integer)fb.getValue((Property)FireBlock.AGE)).intValue()) != 0) {
                level.setBlock(frontPos, (BlockState)fb.setValue((Property)FireBlock.AGE, (Comparable)Integer.valueOf(Mth.clamp((int)(age - 7), (int)0, (int)15))), 4);
            }
            frontPos = frontPos.relative(facing);
        }
    }

    private float getPeriodForPower(int power) {
        return (float)CommonConfigs.Redstone.BELLOWS_PERIOD.get().intValue() - (float)(power - 1) * (float)CommonConfigs.Redstone.BELLOWS_POWER_SCALING.get().intValue();
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BellowsBlockTile tile) {
        int power = (Integer)state.getValue((Property)BellowsBlock.POWER);
        tile.prevHeight = tile.height;
        if (power != 0 && (tile.startTime != 0L || tile.height == 0.0f)) {
            boolean blowing;
            long time = level.getGameTime();
            if (tile.startTime == 0L) {
                tile.startTime = time;
            }
            float period = tile.getPeriodForPower(power);
            float arg = (float)Math.PI * 2 * ((float)(time - tile.startTime) / period % 1.0f);
            float sin = Mth.sin((float)arg);
            float cos = Mth.cos((float)arg);
            float half = 0.0625f;
            tile.height = half * cos - half;
            tile.pushAir(level, pos, state, power, time, period, sin);
            boolean bl = blowing = Mth.sin((float)(arg - 0.8f)) > 0.0f;
            if (tile.lastBlowing != blowing) {
                level.playSound(null, pos, blowing ? ModSounds.BELLOWS_BLOW.get() : ModSounds.BELLOWS_RETRACT.get(), SoundSource.BLOCKS, 0.1f, MthUtils.nextWeighted((RandomSource)level.random, (float)0.1f) + 0.85f + 0.6f * (float)power / 15.0f);
            }
            tile.lastBlowing = blowing;
        } else if (tile.isPressed) {
            float minH = -0.125f;
            tile.height = Math.max(tile.height - 0.01f, minH);
            if (tile.height > minH) {
                long time = level.getGameTime();
                int p = 7;
                float period = tile.getPeriodForPower(p);
                tile.pushAir(level, pos, state, p, time, period, 0.8f);
            }
        } else {
            tile.startTime = 0L;
            if (tile.height < 0.0f) {
                tile.height = Math.min(tile.height + 0.01f, 0.0f);
            }
        }
        if (tile.prevHeight != 0.0f && tile.height != 0.0f) {
            tile.moveCollidedEntities(level);
        }
        if (tile.manualPress > 0) {
            --tile.manualPress;
            tile.isPressed = true;
        } else {
            tile.isPressed = false;
        }
    }

    private void pushAir(Level level, BlockPos pos, BlockState state, int power, long time, float period, float airIntensity) {
        Direction facing = (Direction)state.getValue((Property)BellowsBlock.FACING);
        BlockPos frontPos = pos.relative(facing);
        FluidState fluid = level.getFluidState(frontPos);
        if (level.isClientSide) {
            this.blowParticles(airIntensity, facing, level, fluid.getType().is(FluidTags.WATER));
        } else if (fluid.isEmpty()) {
            float range = CommonConfigs.Redstone.BELLOWS_RANGE.get().intValue();
            if (airIntensity > 0.0f) {
                this.pushEntities(facing, period, range, level);
            }
            if (time % (long)(10 - power / 2) == 0L) {
                this.tickFurnaces(frontPos, level);
            }
            int n = 0;
            int a = 0;
            while ((float)a <= range) {
                if (time % (15L * (long)(a + 1)) != 0L) {
                    n = a;
                    break;
                }
                ++a;
            }
            this.refreshFire(n, facing, frontPos, level);
        }
    }

    public boolean inLineOfSight(Entity entity, Direction facing, Level level) {
        int x = facing.getStepX() * (Mth.floor((double)entity.getX()) - this.worldPosition.getX());
        int y = facing.getStepY() * (Mth.floor((double)entity.getY()) - this.worldPosition.getY());
        int z = facing.getStepZ() * (Mth.floor((double)entity.getZ()) - this.worldPosition.getZ());
        boolean flag = true;
        for (int i = 1; i < Math.abs(x + y + z); ++i) {
            if (!Block.canSupportCenter((LevelReader)level, (BlockPos)this.worldPosition.relative(facing, i), (Direction)facing.getOpposite())) continue;
            flag = false;
        }
        return flag;
    }

    protected void spawnParticle(Level world, BlockPos pos, Direction dir, AirType airType) {
        if (airType == AirType.SOAP) {
            for (int m = 0; m < 1 + world.random.nextInt(3); ++m) {
                ParticleUtil.spawnParticleOnFace((Level)world, (BlockPos)pos, (Direction)dir, (ParticleOptions)((ParticleOptions)ModParticles.SUDS_PARTICLE.get()), (float)0.3f, (float)0.5f, (boolean)true);
            }
        } else {
            double xo = dir.getStepX();
            double yo = dir.getStepY();
            double zo = dir.getStepZ();
            double x = xo * 0.5 + (double)pos.getX() + 0.5 + ((double)world.random.nextFloat() - 0.5) / 3.0;
            double y = yo * 0.5 + (double)pos.getY() + 0.5 + ((double)world.random.nextFloat() - 0.5) / 3.0;
            double z = zo * 0.5 + (double)pos.getZ() + 0.5 + ((double)world.random.nextFloat() - 0.5) / 3.0;
            double vel = 0.125f + world.random.nextFloat() * 0.2f;
            double velX = xo * vel;
            double velY = yo * vel;
            double velZ = zo * vel;
            if (airType == AirType.BUBBLE) {
                world.addParticle((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, velX * 0.8, velY * 0.8, velZ * 0.8);
            } else {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, velX, velY, velZ);
            }
        }
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)BellowsBlock.FACING);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.startTime = tag.getLong("Offset");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong("Offset", this.startTime);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onSteppedOn(Entity entityIn) {
        if (this.isPressed) {
            return;
        }
        double b = entityIn.getBoundingBox().getSize();
        if (b > 0.8 && ((Direction)this.getBlockState().getValue((Property)BellowsBlock.FACING)).getAxis() != Direction.Axis.Y) {
            this.isPressed = true;
        }
    }

    protected static enum AirType {
        AIR,
        BUBBLE,
        SOAP;

    }
}

