/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SusGravelBricksTile
extends RandomizableContainerBlockEntity {
    protected NonNullList<ItemStack> items = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public SusGravelBricksTile(BlockPos pos, BlockState blockState) {
        super(ModRegistry.SUS_GRAVEL_BRICKS_TILE.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!((ItemStack)this.items.get(0)).isEmpty()) {
            tag.put("item", ((ItemStack)this.items.get(0)).save(registries));
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item", 10)) {
            this.items.set(0, (Object)ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item")));
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("item");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean canTakeItem(Container container, int i, ItemStack itemStack) {
        return false;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return false;
    }

    public boolean canOpen(Player player) {
        return false;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.supplementaries.suspicious_gravel_bricks");
    }

    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return ChestMenu.threeRows((int)containerId, (Inventory)inventory, (Container)this);
    }
}

