/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.block.IAntiquable;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.network.Filterable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class AntiqueInkItem
extends Item
implements SignApplicator {
    public AntiqueInkItem(Item.Properties properties) {
        super(properties);
    }

    public boolean tryApplyToSign(Level level, SignBlockEntity signBlockEntity, boolean front, Player player) {
        return AntiqueInkItem.toggleAntiqueInkOnSigns(level, player, signBlockEntity.getBlockPos(), (BlockEntity)signBlockEntity, true);
    }

    public static boolean isEnabled() {
        return PlatHelper.getPlatform().isForge() && CommonConfigs.Tools.ANTIQUE_INK_ENABLED.get() != false;
    }

    public static boolean toggleAntiqueInkOnSigns(Level world, Player player, BlockPos pos, BlockEntity tile, boolean newState) {
        IAntiquable cap = SuppPlatformStuff.getForgeCap(tile, IAntiquable.class);
        boolean success = false;
        if (cap != null && cap.supplementaries$isAntique() != newState) {
            cap.supplementaries$setAntique(newState);
            tile.setChanged();
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                NetworkHelper.sendToAllClientPlayersInRange((ServerLevel)serverLevel, (BlockPos)pos, (double)256.0, (CustomPacketPayload)new ClientBoundSyncAntiqueInk(pos, newState));
            }
            success = true;
        }
        if (success) {
            if (newState) {
                world.playSound(null, pos, SoundEvents.GLOW_INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else {
                world.playSound(null, pos, SoundEvents.INK_SAC_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    public static void setAntiqueInk(BlockEntity tile, boolean ink) {
        IAntiquable cap = SuppPlatformStuff.getForgeCap(tile, IAntiquable.class);
        if (cap != null) {
            cap.supplementaries$setAntique(ink);
        }
    }

    public static void setAntiqueInk(ItemStack stack, boolean ink) {
        if (ink) {
            stack.set(ModComponents.ANTIQUE_INK.get(), (Object)Unit.INSTANCE);
            WrittenBookContent written = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
            if (written != null) {
                Filterable title = written.title();
                String author = written.author();
                List pages = written.pages();
                ArrayList<Filterable> newPages = new ArrayList<Filterable>(pages.size());
                for (Filterable page : pages) {
                    Object t;
                    Component comp = (Component)page.raw();
                    Optional<MutableComponent> optional = page.filtered();
                    if (comp instanceof MutableComponent) {
                        MutableComponent mc = (MutableComponent)comp;
                        comp = mc.withStyle(mc.getStyle().withFont(ModTextures.ANTIQUABLE_FONT));
                    }
                    if (optional.isPresent() && (t = optional.get()) instanceof MutableComponent) {
                        MutableComponent mc2 = (MutableComponent)t;
                        optional = Optional.of(mc2.withStyle(mc2.getStyle().withFont(ModTextures.ANTIQUABLE_FONT)));
                    }
                    newPages.add(new Filterable((Object)comp, (Optional)optional));
                }
                stack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(title, author, 3, newPages, false));
            }
        } else {
            stack.remove(ModComponents.ANTIQUE_INK.get());
            WrittenBookContent written = (WrittenBookContent)stack.get(DataComponents.WRITTEN_BOOK_CONTENT);
            if (written != null) {
                Filterable title = written.title();
                String author = written.author();
                int generation = written.generation();
                List pages = written.pages();
                ArrayList<Filterable> newPages = new ArrayList<Filterable>(pages.size());
                for (Filterable page : pages) {
                    Object t;
                    Component comp = (Component)page.raw();
                    Optional<MutableComponent> optional = page.filtered();
                    if (comp instanceof MutableComponent) {
                        MutableComponent mc = (MutableComponent)comp;
                        comp = mc.withStyle(mc.getStyle().withFont(null));
                    }
                    if (optional.isPresent() && (t = optional.get()) instanceof MutableComponent) {
                        MutableComponent mc2 = (MutableComponent)t;
                        optional = Optional.of(mc2.withStyle(mc2.getStyle().withFont(null)));
                    }
                    newPages.add(new Filterable((Object)comp, (Optional)optional));
                }
                stack.set(DataComponents.WRITTEN_BOOK_CONTENT, (Object)new WrittenBookContent(title, author, 0, newPages, false));
            }
        }
    }

    public static boolean hasAntiqueInk(ItemStack stack) {
        return stack.get(ModComponents.ANTIQUE_INK.get()) != null;
    }
}

