/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.items.tooltip_components.InventoryViewTooltip;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkClientCompat;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.integration.ShulkerBoxTooltipCompat;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.Block;

public class SafeItem
extends BlockItem {
    public SafeItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, incoming, slot, action, player, true);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (!CompatHandler.QUARK || !QuarkCompat.isShulkerDropInOn()) {
            return false;
        }
        return ItemsUtil.tryInteractingWithContainerItem(stack, slot.getItem(), slot, action, player, false);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        ItemContainerContents container;
        boolean sbtTooltip;
        boolean quarkTooltip = CompatHandler.QUARK && QuarkClientCompat.canRenderBlackboardTooltip();
        boolean bl = sbtTooltip = CompatHandler.SHULKER_BOX_TOOLTIP && ShulkerBoxTooltipCompat.hasPreviewProvider(pStack);
        if (quarkTooltip && !sbtTooltip && (container = (ItemContainerContents)pStack.get(DataComponents.CONTAINER)) != null && !pStack.has(DataComponents.CONTAINER_LOOT)) {
            return Optional.of(new InventoryViewTooltip(container, 27));
        }
        return Optional.empty();
    }
}

