/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_data;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.WeatheredHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DepthDataHandler {
    private static final String DEPTH_LOCK_KEY = "depth_lock";
    public static final CustomMapData.Type<Optional<Integer>, DepthMapData> DEPTH_DATA_KEY = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res("depth_lock"), DepthMapData::new, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VAR_INT));
    private static final RandomSource RAND = RandomSource.createNewThreadLocalInstance();

    public static void init() {
    }

    public static Optional<Integer> getMapHeight(MapItemSavedData data) {
        return ((DepthMapData)DEPTH_DATA_KEY.get(data)).getValue();
    }

    public static ItemStack createSliceMap(Level level, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, int slice) {
        ItemStack itemStack = new ItemStack((ItemLike)Items.FILLED_MAP);
        MapItemSavedData data = MapItemSavedData.createFresh((double)x, (double)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking, (ResourceKey)level.dimension());
        DepthMapData instance = (DepthMapData)DEPTH_DATA_KEY.get(data);
        instance.set(slice);
        instance.setDirty(data, CustomMapData.SimpleDirtyCounter::markDirty);
        MapId mapId = level.getFreeMapId();
        level.setMapData(mapId, data);
        itemStack.set(DataComponents.MAP_ID, (Object)mapId);
        return itemStack;
    }

    public static MapColor getCutoffColor(BlockPos pos, BlockGetter level) {
        return (pos.getX() + pos.getZ()) % 2 == 0 ? MapColor.NONE : WeatheredHandler.ANTIQUE_LIGHT;
    }

    public static double getRangeMultiplier() {
        return CommonConfigs.Tools.SLICE_MAP_RANGE.get();
    }

    public static boolean canPlayerSee(int targetY, Entity entity) {
        Level level = entity.level();
        int py = entity.getBlockY();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int spread = 3;
        p.set((Vec3i)entity.blockPosition().offset(RAND.nextInt(spread) - RAND.nextInt(spread), 0, RAND.nextInt(spread) - RAND.nextInt(spread)));
        int direction = Integer.compare(targetY, py);
        while (p.getY() != targetY) {
            if (level.getBlockState((BlockPos)p).getMapColor((BlockGetter)level, (BlockPos)p) != MapColor.NONE) {
                return false;
            }
            p.setY(p.getY() + direction);
        }
        return true;
    }

    public static class DepthMapData
    extends CustomMapData.Simple<Optional<Integer>> {
        public DepthMapData() {
            super(Optional.empty());
        }

        @NotNull
        public Optional<Integer> getValue() {
            return (Optional)this.value;
        }

        public void load(CompoundTag tag, HolderLookup.Provider provider) {
            int anInt;
            this.value = tag.contains(DepthDataHandler.DEPTH_LOCK_KEY) ? ((anInt = tag.getInt(DepthDataHandler.DEPTH_LOCK_KEY)) != Integer.MAX_VALUE ? Optional.of(anInt) : Optional.empty()) : Optional.empty();
        }

        public void save(CompoundTag tag, HolderLookup.Provider provider) {
            ((Optional)this.value).ifPresent(integer -> tag.putInt(DepthDataHandler.DEPTH_LOCK_KEY, integer.intValue()));
        }

        public CustomMapData.Type<Optional<Integer>, DepthMapData> getType() {
            return DEPTH_DATA_KEY;
        }

        @Nullable
        public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
            return ((Optional)this.value).map(integer -> Component.translatable((String)"filled_map.sliced.tooltip", (Object[])new Object[]{integer}).withStyle(ChatFormatting.GRAY)).orElse(null);
        }

        public void set(int slice) {
            this.value = Optional.of(slice);
        }

        public CustomMapData.SimpleDirtyCounter createDirtyCounter() {
            return new CustomMapData.SimpleDirtyCounter();
        }
    }
}

