/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_markers;

import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapMarker;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLSpecialMapDecorationType;
import net.mehvahdjukaar.moonlight.api.map.decoration.SimpleMapMarker;
import net.mehvahdjukaar.moonlight.api.misc.HolderReference;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SignPostBlockTile;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredDecoration;
import net.mehvahdjukaar.supplementaries.common.misc.map_markers.ColoredMarker;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.WaystonesCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class ModMapMarkers {
    public static final HolderReference<MLMapDecorationType<?, ?>> DEATH_MARKER = HolderReference.of((ResourceLocation)Supplementaries.res("death_marker"), (ResourceKey)MapDataRegistry.MAP_DECORATION_REGISTRY_KEY);
    public static final ResourceLocation WAY_SIGN_FACTORY_ID = Supplementaries.res("way_sign");
    public static final ResourceLocation WAYSTONE_FACTORY_ID = Supplementaries.res("waystone");
    public static final ResourceLocation BANNER_FACTORY_ID = Supplementaries.res("banner");
    public static final ResourceLocation BED_FACTORY_ID = Supplementaries.res("bed");
    public static final ResourceLocation FLAG_FACTORY_ID = Supplementaries.res("flag");

    public static void init() {
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((ResourceLocation)WAY_SIGN_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldSimple(ModMapMarkers::signPost));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((ResourceLocation)WAYSTONE_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldSimple(ModMapMarkers::waystone));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((ResourceLocation)BANNER_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::banner));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((ResourceLocation)BED_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::bed));
        MapDataRegistry.registerSpecialMapDecorationTypeFactory((ResourceLocation)FLAG_FACTORY_ID, () -> MLSpecialMapDecorationType.fromWorldCustomMarker(ColoredMarker.DIRECT_CODEC, ColoredDecoration.DIRECT_CODEC, ModMapMarkers::flag));
        MapDataRegistry.addDynamicServerMarkersEvent(ModMapMarkers::getForPlayer);
    }

    public static Set<MLMapMarker<?>> getForPlayer(Player player, MapId mapId, MapItemSavedData data) {
        Optional v = player.getLastDeathLocation();
        if (v.isPresent() && data.dimension.equals(((GlobalPos)v.get()).dimension()) && CommonConfigs.Tweaks.DEATH_MARKER.get().isOn(player)) {
            SimpleMapMarker marker = new SimpleMapMarker(DEATH_MARKER.getHolder((Entity)player), ((GlobalPos)v.get()).pos(), Float.valueOf(0.0f), Optional.of(Component.translatable((String)"message.supplementaries.death_marker")));
            return Set.of(marker);
        }
        return Set.of();
    }

    @Nullable
    private static SimpleMapMarker signPost(Holder<MLMapDecorationType<?, ?>> type, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SignPostBlockTile) {
            SignPostBlockTile tile = (SignPostBlockTile)blockEntity;
            MutableComponent t = Component.literal((String)"");
            if (tile.getSignUp().active()) {
                t = tile.getTextHolder(0).getMessage(0, false);
            }
            if (tile.getSignDown().active() && t.getString().isEmpty()) {
                t = tile.getTextHolder(1).getMessage(0, false);
            }
            if (t.getString().isEmpty()) {
                t = null;
            }
            return new SimpleMapMarker(type, pos, Float.valueOf(0.0f), Optional.ofNullable(t));
        }
        return null;
    }

    @Nullable
    private static ColoredMarker bed(Holder<MLMapDecorationType<?, ?>> type, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BedBlockEntity) {
            BedBlockEntity tile = (BedBlockEntity)blockEntity;
            DyeColor dyecolor = tile.getColor();
            return new ColoredMarker(type, pos, dyecolor);
        }
        return null;
    }

    @Nullable
    private static ColoredMarker flag(Holder<MLMapDecorationType<?, ?>> type, BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FlagBlockTile) {
            FlagBlockTile tile = (FlagBlockTile)blockEntity;
            DyeColor dyecolor = tile.getColor();
            Component name = tile.hasCustomName() ? tile.getCustomName() : null;
            return new ColoredMarker(type, pos, name, dyecolor);
        }
        return null;
    }

    @Nullable
    private static ColoredMarker banner(Holder<MLMapDecorationType<?, ?>> type, BlockGetter world, BlockPos pos) {
        DyeColor col;
        Block block = world.getBlockState(pos).getBlock();
        if (block instanceof AbstractBannerBlock && !(block instanceof WallBannerBlock) && !(block instanceof BannerBlock) && (col = BlocksColorAPI.getColor((Block)block)) != null) {
            Nameable n;
            BlockEntity be = world.getBlockEntity(pos);
            Component name = be instanceof Nameable && (n = (Nameable)be).hasCustomName() ? n.getCustomName() : null;
            return new ColoredMarker(type, pos, name, col);
        }
        return null;
    }

    @Nullable
    private static SimpleMapMarker waystone(Holder<MLMapDecorationType<?, ?>> type, BlockGetter world, BlockPos pos) {
        BlockEntity te;
        if (CompatHandler.WAYSTONES && WaystonesCompat.isWaystone(te = world.getBlockEntity(pos))) {
            Component name = WaystonesCompat.getName(te);
            return new SimpleMapMarker(type, pos, Float.valueOf(0.0f), Optional.of(name));
        }
        return null;
    }
}

