/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BucketHelper;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.CapturedMobHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainer {
    private final float width;
    private final float height;
    private final boolean isAquarium;
    @Nullable
    private MobData data;
    @Nullable
    private CapturedMobInstance<?> mobInstance;
    private ICatchableMob mobProperties;
    private boolean needsInitialization = false;

    public MobContainer(float width, float height, boolean isAquarium) {
        this.width = width;
        this.height = height;
        this.isAquarium = isAquarium;
    }

    public MobContainer makeCopy() {
        MobContainer container = new MobContainer(this.width, this.height, this.isAquarium);
        container.setData(this.data);
        return container;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        if (this.data != null) {
            Object object;
            RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            RecordBuilder mapBuilder = ops.mapBuilder();
            MobData.CODEC.encode((Object)this.data, (DynamicOps)ops, mapBuilder);
            DataResult newTag = mapBuilder.build((Object)tag);
            if (newTag.isSuccess() && (object = newTag.getOrThrow()) instanceof CompoundTag) {
                CompoundTag ct = (CompoundTag)object;
                tag.merge(ct);
            }
        }
        return tag;
    }

    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ops.getMap((Object)tag).ifSuccess(map -> MobData.CODEC.decode((DynamicOps)ops, map).ifSuccess(this::setData));
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public boolean isAquarium() {
        return this.isAquarium;
    }

    public void setData(@Nullable MobData data) {
        this.data = data;
        this.needsInitialization = true;
    }

    private void initializeEntity(Level level, @Nullable BlockPos pos) {
        this.needsInitialization = false;
        if (this.data != null) {
            MobData mobData = this.data;
            if (mobData instanceof MobData.Bucket) {
                MobData.Bucket bucketData = (MobData.Bucket)mobData;
                type = BucketHelper.getEntityTypeFromBucket(bucketData.filledBucket.getItem());
                this.mobProperties = CapturedMobHandler.getInstance((HolderLookup.Provider)level.registryAccess()).getDataCap(type, true);
            } else {
                MobData.Entity entityData;
                Entity entity;
                type = this.data;
                if (type instanceof MobData.Entity && (entity = MobContainer.createStaticMob(entityData = (MobData.Entity)type, level, pos == null ? BlockPos.ZERO : pos)) != null) {
                    this.mobProperties = CapturedMobHandler.getInstance(level).getCatchableMobCapOrDefault(entity);
                    this.mobInstance = this.mobProperties.createCapturedMobInstance(entity, this.width, this.height);
                    if (pos != null) {
                        this.mobInstance.onContainerWaterlogged(level.getFluidState(pos).getType() != Fluids.EMPTY, this.width, this.height);
                        if (!level.isClientSide) {
                            this.updateLightLevel(level, pos);
                        }
                    }
                }
            }
        }
    }

    public void updateLightLevel(Level level, BlockPos pos) {
        int light = 0;
        if (level != null && !level.isClientSide && this.data != null) {
            BlockState state;
            if (this.mobProperties != null) {
                light = this.mobProperties.getLightLevel(level, pos);
            }
            if ((Integer)(state = level.getBlockState(pos)).getValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15) != light) {
                level.setBlock(pos, (BlockState)state.setValue((Property)ModBlockProperties.LIGHT_LEVEL_0_15, (Comparable)Integer.valueOf(light)), 22);
            }
        }
    }

    @Nullable
    public static Entity createStaticMob(MobData.Entity data, @NotNull Level world, BlockPos pos) {
        Entity entity = null;
        if (data != null) {
            entity = MobContainer.createEntityFromNBT(data.mobTag, data.uuid, world);
            if (entity == null) {
                return null;
            }
            double px = (double)pos.getX() + entity.getX();
            double py = (double)pos.getY() + entity.getY();
            double pz = (double)pos.getZ() + entity.getZ();
            entity.setPos(px, py, pz);
            entity.xOld = px;
            entity.yOld = py;
            entity.zOld = pz;
            entity.xo = px;
            entity.yo = py;
            entity.zo = pz;
        }
        return entity;
    }

    @Nullable
    public static Entity createEntityFromNBT(CompoundTag tag, @Nullable UUID id, Level world) {
        if (tag != null && tag.contains("id")) {
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)world, o -> o);
            if (id != null && entity != null) {
                entity.setUUID(id);
                if (entity.hasCustomName()) {
                    entity.setCustomName(entity.getCustomName());
                }
            }
            return entity;
        }
        return null;
    }

    public boolean interactWithBucket(ItemStack stack, Level world, BlockPos pos, @Nullable Player player, InteractionHand hand) {
        Item item = stack.getItem();
        ItemStack returnStack = ItemStack.EMPTY;
        if (this.isEmpty()) {
            if (BucketHelper.isFishBucket(item)) {
                world.playSound(null, pos, SoundEvents.BUCKET_EMPTY_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = new ItemStack((ItemLike)Items.BUCKET);
                EntityType<?> type = BucketHelper.getEntityTypeFromBucket(stack.getItem());
                ICatchableMob cap = CapturedMobHandler.getInstance(world).getDataCap(type, true);
                Optional<Holder<SoftFluid>> f = cap.getForceFluid();
                if (stack.isEmpty()) {
                    Supplementaries.LOGGER.error("Bucket error 3: name none, bucket {}", (Object)stack);
                }
                MobData.Bucket data = new MobData.Bucket(Optional.empty(), stack.copy(), cap.getFishTextureIndex(), f);
                this.setData(data);
            }
        } else if (item == Items.BUCKET) {
            ItemStack bucket;
            Object temp;
            MobData cap = this.data;
            if (cap instanceof MobData.Bucket) {
                MobData.Bucket bucketData = (MobData.Bucket)cap;
                world.playSound(null, pos, SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = bucketData.filledBucket.copy();
                this.setData(null);
            } else if (this.data instanceof MobData.Entity && this.mobInstance != null && (temp = this.mobInstance.getEntityForRenderer()) != null && !(bucket = BucketHelper.getBucketFromEntity(temp)).isEmpty()) {
                world.playSound(null, pos, SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
                returnStack = bucket.copy();
                this.setData(null);
            }
        }
        if (!returnStack.isEmpty()) {
            if (player != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)item));
                if (!player.isCreative()) {
                    Utils.swapItem((Player)player, (InteractionHand)hand, (ItemStack)returnStack);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null;
    }

    public void tick(Level pLevel, BlockPos pPos) {
        MobData mobData;
        if (this.needsInitialization) {
            this.initializeEntity(pLevel, pPos);
        }
        if (this.mobInstance != null && (mobData = this.data) instanceof MobData.Entity) {
            MobData.Entity entityData = (MobData.Entity)mobData;
            this.mobInstance.containerTick(pLevel, pPos, entityData.scale, entityData.mobTag);
        }
    }

    public ItemInteractionResult onInteract(Level world, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        MobData mobData;
        if (this.mobInstance != null && (mobData = this.data) instanceof MobData.Entity) {
            MobData.Entity entityData = (MobData.Entity)mobData;
            return this.mobInstance.onPlayerInteract(world, pos, player, hand, stack, entityData.mobTag);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public MobData getData() {
        return this.data;
    }

    @Nullable
    public Entity getDisplayedMob(Level level, @Nullable BlockPos pos) {
        if (this.needsInitialization) {
            this.initializeEntity(level, pos);
        }
        if (this.mobInstance != null) {
            return this.mobInstance.getEntityForRenderer();
        }
        return null;
    }

    public Optional<Holder<SoftFluid>> shouldRenderWithFluid() {
        if (this.data == null || !this.isAquarium || this.mobProperties == null) {
            return Optional.empty();
        }
        return this.mobProperties.getForceFluid();
    }

    public boolean captureEntity(Entity mob, ItemStack bucketStack) {
        MobData newData;
        String name = mob.getName().getString();
        ICatchableMob cap = CapturedMobHandler.getInstance(mob.level()).getCatchableMobCapOrDefault(mob);
        if (this.isAquarium && !bucketStack.isEmpty() && cap.renderAs2DFish()) {
            Optional<Holder<SoftFluid>> f = cap.getForceFluid();
            if (bucketStack.isEmpty()) {
                Supplementaries.LOGGER.error("Bucket error 2: name {}, bucket {}", (Object)name, (Object)bucketStack);
            }
            newData = new MobData.Bucket(Optional.of(name), bucketStack, cap.getFishTextureIndex(), f);
        } else {
            Pair<Float, Float> dimensions = MobContainer.calculateMobDimensionsForContainer(mob, this.width, this.height, this.isAquarium);
            float scale = ((Float)dimensions.getLeft()).floatValue();
            float yOffset = ((Float)dimensions.getRight()).floatValue();
            CompoundTag mobTag = MobContainer.prepareMobTagForContainer(mob, yOffset);
            if (mobTag == null) {
                return false;
            }
            UUID id = mob.getUUID();
            newData = new MobData.Entity(name, mobTag, scale, id);
        }
        this.setData(newData);
        return true;
    }

    @Nullable
    private static CompoundTag prepareMobTagForContainer(Entity entity, double yOffset) {
        Mob mob;
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.setPos(px, py, pz);
        entity.xOld = px;
        entity.yOld = py;
        entity.zOld = pz;
        if (entity.isPassenger()) {
            entity.getVehicle().ejectPassengers();
        }
        if (entity instanceof Mob && !((mob = (Mob)entity) instanceof Allay) && entity instanceof Bucketable) {
            mob.setPersistenceRequired();
        }
        if (entity instanceof Bucketable) {
            Bucketable bucketable = (Bucketable)entity;
            bucketable.setFromBucket(true);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.yHeadRotO = 0.0f;
            le.yHeadRot = 0.0f;
            le.walkAnimation.setSpeed(0.0f);
            le.walkAnimation.update(-le.walkAnimation.position(), 1.0f);
            le.walkAnimation.setSpeed(0.0f);
            le.hurtDuration = 0;
            le.hurtTime = 0;
            le.attackAnim = 0.0f;
        }
        entity.setYRot(0.0f);
        entity.yRotO = 0.0f;
        entity.xRotO = 0.0f;
        entity.setXRot(0.0f);
        entity.clearFire();
        entity.invulnerableTime = 0;
        if (entity instanceof Bat) {
            Bat bat = (Bat)entity;
            bat.setResting(true);
        }
        if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.setSleeping(true);
        }
        if (entity instanceof AbstractFish) {
            AbstractFish abstractFish = (AbstractFish)entity;
            abstractFish.setFromBucket(true);
        }
        CompoundTag mobTag = new CompoundTag();
        entity.save(mobTag);
        if (mobTag.isEmpty()) {
            Supplementaries.LOGGER.error("failed to capture entity " + String.valueOf(entity) + "Something went wrong :/");
            return null;
        }
        mobTag.remove("Passengers");
        mobTag.remove("Leash");
        mobTag.remove("UUID");
        if (mobTag.contains("FromBucket")) {
            mobTag.putBoolean("FromBucket", true);
        }
        if (mobTag.contains("FromPot")) {
            mobTag.putBoolean("FromPot", true);
        }
        return mobTag;
    }

    public static Pair<Float, Float> calculateMobDimensionsForContainer(Entity mob, float blockW, float blockH, boolean waterlogged) {
        float yOffset;
        String name;
        LivingEntity livingEntity;
        ICatchableMob cap = CapturedMobHandler.getInstance(mob.level()).getCatchableMobCapOrDefault(mob);
        float babyScale = 1.0f;
        if (mob instanceof LivingEntity && (livingEntity = (LivingEntity)mob).isBaby()) {
            babyScale = mob instanceof Villager ? 1.125f : (mob instanceof AgeableMob ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.getBbWidth() * babyScale;
        float h = mob.getBbHeight() * babyScale;
        boolean isAir = cap.shouldHover(mob, waterlogged);
        float aW = w + cap.getHitBoxWidthIncrement(mob);
        float aH = h + cap.getHitBoxHeightIncrement(mob);
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = blockH - 2.0f * (isAir ? margin : yMargin);
        float maxW = blockW - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = Utils.getID((EntityType)mob.getType()).toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale *= 0.45f;
        }
        float f = yOffset = isAir ? blockH / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof Bat) {
            yOffset *= 1.5f;
        }
        return new ImmutablePair((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }

    public void clear() {
        this.setData(null);
    }

    public static abstract class MobData {
        public static final MapCodec<MobData> CODEC = MapCodec.recursive((String)"mobData", s -> Codec.mapEither((MapCodec)Bucket.CODEC.fieldOf("MobHolder"), (MapCodec)Entity.CODEC.fieldOf("BucketHolder")).xmap(Either::unwrap, e -> e instanceof Bucket ? Either.left((Object)((Bucket)e)) : Either.right((Object)((Entity)e))));
        public static final StreamCodec<RegistryFriendlyByteBuf, MobData> STREAM_CODEC = StreamCodec.recursive(s -> ByteBufCodecs.either(Bucket.STREAM_CODEC, Entity.STREAM_CODEC).map(Either::unwrap, e -> {
            Either either;
            if (e instanceof Bucket) {
                Bucket b = (Bucket)e;
                either = Either.left((Object)b);
            } else {
                either = Either.right((Object)((Entity)e));
            }
            return either;
        }));
        protected final String name;
        protected final int fishTexture;
        @Nullable
        protected final Holder<SoftFluid> visualFluid;

        private MobData(String name, int fishTexture, @Nullable Holder<SoftFluid> fluidID) {
            this.name = name;
            this.fishTexture = fishTexture;
            this.visualFluid = fluidID;
        }

        public boolean is2DFish() {
            return this.fishTexture != 0;
        }

        public int getFishTexture() {
            return this.fishTexture;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public Holder<SoftFluid> getVisualFluid() {
            return this.visualFluid;
        }

        public static class Bucket
        extends MobData {
            public static final Codec<Bucket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("Name").forGetter(b -> Optional.ofNullable(b.name)), (App)ItemStack.CODEC.fieldOf("Bucket").forGetter(b -> b.filledBucket), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("FishTexture", (Object)0).forGetter(MobData::getFishTexture), (App)SoftFluid.HOLDER_CODEC.optionalFieldOf("Fluid").forGetter(b -> Optional.ofNullable(b.visualFluid))).apply((Applicative)instance, Bucket::new)).validate(b -> {
                if (b.filledBucket.isEmpty()) {
                    return DataResult.error(() -> "Bucket item cannot be empty");
                }
                return DataResult.success((Object)b);
            });
            public static final StreamCodec<RegistryFriendlyByteBuf, Bucket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), b -> Optional.ofNullable(b.name), (StreamCodec)ItemStack.STREAM_CODEC, b -> b.filledBucket, (StreamCodec)ByteBufCodecs.VAR_INT, MobData::getFishTexture, (StreamCodec)ByteBufCodecs.optional((StreamCodec)SoftFluid.STREAM_CODEC), b -> Optional.ofNullable(b.visualFluid), Bucket::new);
            private final ItemStack filledBucket;

            protected Bucket(Optional<String> name, ItemStack filledBucket, int fishTexture, Optional<Holder<SoftFluid>> fluidId) {
                super(Bucket.getDefaultName(name, filledBucket), fishTexture, (Holder<SoftFluid>)((Holder)fluidId.orElse(null)));
                this.filledBucket = filledBucket;
            }

            private static String getDefaultName(Optional<String> name, ItemStack filledBucket) {
                if (name.isEmpty()) {
                    EntityType<?> type = BucketHelper.getEntityTypeFromBucket(filledBucket.getItem());
                    return type == null ? "Mob" : type.getDescriptionId();
                }
                return name.get();
            }

            public ItemStack getBucket() {
                return this.filledBucket;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Bucket bucket = (Bucket)o;
                return Objects.equals(this.filledBucket, bucket.filledBucket);
            }

            public int hashCode() {
                return Objects.hashCode(this.filledBucket);
            }
        }

        public static class Entity
        extends MobData {
            public static final Codec<Entity> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("Name").forGetter(MobData::getName), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("FishTexture", (Object)0).forGetter(MobData::getFishTexture), (App)SoftFluid.HOLDER_CODEC.optionalFieldOf("Fluid").forGetter(e -> Optional.ofNullable(e.visualFluid)), (App)CompoundTag.CODEC.fieldOf("EntityData").forGetter(e -> e.mobTag), (App)Codec.FLOAT.fieldOf("Scale").forGetter(Entity::getScale), (App)UUIDUtil.CODEC.fieldOf("UUID").forGetter(e -> e.uuid)).apply((Applicative)instance, Entity::new));
            public static final StreamCodec<RegistryFriendlyByteBuf, Entity> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, MobData::getName, (StreamCodec)ByteBufCodecs.VAR_INT, MobData::getFishTexture, (StreamCodec)ByteBufCodecs.optional((StreamCodec)SoftFluid.STREAM_CODEC), e -> Optional.ofNullable(e.visualFluid), (StreamCodec)ByteBufCodecs.COMPOUND_TAG, e -> e.mobTag, (StreamCodec)ByteBufCodecs.FLOAT, Entity::getScale, (StreamCodec)UUIDUtil.STREAM_CODEC, e -> e.uuid, Entity::new);
            private final CompoundTag mobTag;
            private final float scale;
            @Nullable
            private final UUID uuid;

            protected Entity(String name, CompoundTag tag, float scale, UUID uuid) {
                this(name, 0, Optional.empty(), tag, scale, uuid);
            }

            protected Entity(String name, int fishTexture, Optional<Holder<SoftFluid>> visualFluid, CompoundTag tag, float scale, UUID uuid) {
                super(name, fishTexture, (Holder<SoftFluid>)((Holder)visualFluid.orElse(null)));
                this.mobTag = tag;
                this.scale = scale;
                this.uuid = uuid;
            }

            public MobData copyWithNewUUID(UUID newUUID) {
                return new Entity(this.name, this.fishTexture, Optional.ofNullable(this.visualFluid), this.mobTag, this.scale, newUUID);
            }

            public float getScale() {
                return this.scale;
            }

            public CompoundTag getTag() {
                return this.mobTag;
            }

            @Nullable
            public UUID getUuid() {
                return this.uuid;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entity entity = (Entity)o;
                return Float.compare(this.scale, entity.scale) == 0 && Objects.equals(this.mobTag, entity.mobTag) && Objects.equals(this.uuid, entity.uuid);
            }

            public int hashCode() {
                return Objects.hash(this.mobTag, Float.valueOf(this.scale), this.uuid);
            }
        }
    }
}

