/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import java.util.Optional;
import net.mehvahdjukaar.supplementaries.common.entities.RedMerchantEntity;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.storage.ServerLevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class RedMerchantSpawnerMixin {
    @Shadow
    @Final
    private RandomSource random;
    @Final
    @Shadow
    private ServerLevelData serverLevelData;
    @Unique
    private int supplementaries$redSpawnDelay = 0;

    @Inject(method={"tick(Lnet/minecraft/server/level/ServerLevel;ZZ)I"}, at={@At(value="HEAD")})
    public void supp$tickRedMerchant(ServerLevel serverLevel, boolean b, boolean b1, CallbackInfoReturnable<Integer> cir) {
        if (this.supplementaries$redSpawnDelay > 0) {
            --this.supplementaries$redSpawnDelay;
        }
    }

    @Inject(method={"spawn(Lnet/minecraft/server/level/ServerLevel;)Z"}, at={@At(value="RETURN")})
    public void supp$spawnRedMerchant(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer player;
        if (!((Boolean)cir.getReturnValue()).booleanValue() && this.supplementaries$redSpawnDelay == 0 && (player = world.getRandomPlayer()) != null && this.random.nextInt(9) == 0) {
            RedMerchantEntity trader;
            PoiManager poiManager;
            Optional optional;
            BlockPos targetPos;
            BlockPos spawnPos;
            BlockPos blockpos = player.blockPosition();
            double mult = RedMerchantSpawnerMixin.supplementaries$getRedMerchantSpawnMultiplier();
            if (mult != 0.0 && (double)this.supplementaries$calculateNormalizeDifficulty(world, blockpos) * mult > (double)(this.random.nextFloat() * 90.0f) && (spawnPos = this.findSpawnPositionNear((LevelReader)world, targetPos = (optional = (poiManager = world.getPoiManager()).find(h -> h.is(PoiTypes.MEETING), pos -> true, blockpos, 48, PoiManager.Occupancy.ANY)).orElse(blockpos), 48)) != null && this.hasEnoughSpace((BlockGetter)world, spawnPos) && !world.getBiome(spawnPos).is(Biomes.THE_VOID) && (trader = (RedMerchantEntity)ModEntities.RED_MERCHANT.get().spawn(world, spawnPos, MobSpawnType.EVENT)) != null) {
                this.serverLevelData.setWanderingTraderId(trader.getUUID());
                int lifetime = 25000;
                trader.setDespawnDelay(lifetime);
                trader.setWanderTarget(targetPos);
                trader.restrictTo(targetPos, 16);
                this.supplementaries$redSpawnDelay = lifetime;
            }
        }
    }

    @Unique
    private static double supplementaries$getRedMerchantSpawnMultiplier() {
        return CommonConfigs.getRedMerchantSpawnMultiplier();
    }

    @Unique
    private float supplementaries$calculateNormalizeDifficulty(ServerLevel world, BlockPos pos) {
        float dragon = 1.0f;
        EndDragonFight.Data dragonData = world.getServer().getWorldData().endDragonFightData();
        if (dragonData.dragonKilled()) {
            dragon = 1.25f;
        }
        long i = 0L;
        float f = 0.0f;
        if (world.hasChunkAt(pos)) {
            f = world.getMoonBrightness();
            i = world.getChunkAt(pos).getInhabitedTime();
        }
        DifficultyInstance instance = new DifficultyInstance(Difficulty.NORMAL, world.getDayTime(), i, f);
        float diff = instance.getEffectiveDifficulty();
        diff = (float)((double)diff - 1.5);
        diff *= 4.0f;
        float scale = switch (world.getDifficulty()) {
            default -> throw new MatchException(null, null);
            case Difficulty.PEACEFUL -> 1.0f;
            case Difficulty.EASY -> 1.25f;
            case Difficulty.NORMAL -> 1.5f;
            case Difficulty.HARD -> 1.75f;
        };
        diff *= scale;
        diff *= dragon;
        if (MiscUtils.FESTIVITY.isChristmas()) {
            diff *= 15.0f;
        }
        return diff;
    }

    @Shadow
    protected abstract boolean hasEnoughSpace(BlockGetter var1, BlockPos var2);

    @Shadow
    protected abstract BlockPos findSpawnPositionNear(LevelReader var1, BlockPos var2, int var3);
}

