/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class CompleteBuildRequestTrigger
extends SimpleCriterionTrigger<CompleteBuildRequestTriggerInstance> {
    public void trigger(ServerPlayer player, String structureName, int level) {
        this.trigger(player, trigger -> trigger.test(structureName, level));
    }

    public Codec<CompleteBuildRequestTriggerInstance> codec() {
        return CompleteBuildRequestTriggerInstance.CODEC;
    }

    public record CompleteBuildRequestTriggerInstance(Optional<ContextAwarePredicate> player, Optional<String> hutName, int level) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final int DEFAULT_LEVEL = -1;
        public static final Codec<CompleteBuildRequestTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(CompleteBuildRequestTriggerInstance::player), (App)Codec.STRING.optionalFieldOf("hut_name").forGetter(CompleteBuildRequestTriggerInstance::hutName), (App)ExtraCodecs.intRange((int)0, (int)5).optionalFieldOf("level", (Object)-1).forGetter(CompleteBuildRequestTriggerInstance::level)).apply((Applicative)builder, CompleteBuildRequestTriggerInstance::new));

        public static Criterion<CompleteBuildRequestTriggerInstance> completeBuildRequest() {
            return CompleteBuildRequestTriggerInstance.completeBuildRequest(null, -1);
        }

        public static Criterion<CompleteBuildRequestTriggerInstance> completeBuildRequest(String hutName) {
            return CompleteBuildRequestTriggerInstance.completeBuildRequest(hutName, -1);
        }

        public static Criterion<CompleteBuildRequestTriggerInstance> completeBuildRequest(String hutName, int level) {
            return ((CompleteBuildRequestTrigger)((Object)AdvancementTriggers.COMPLETE_BUILD_REQUEST.get())).createCriterion((CriterionTriggerInstance)new CompleteBuildRequestTriggerInstance(Optional.empty(), Optional.ofNullable(hutName), level));
        }

        public boolean test(String structureName, int level) {
            if (this.hutName.isPresent() && this.level != -1) {
                return this.hutName.get().equalsIgnoreCase(structureName) && this.level <= level;
            }
            if (this.hutName.isPresent()) {
                return this.hutName.get().equalsIgnoreCase(structureName);
            }
            return true;
        }
    }
}

