/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MinimumStack
extends Stack {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(MinimumStack.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());

    public MinimumStack(@NotNull ItemStack stack) {
        this(stack, true);
    }

    public MinimumStack(@NotNull ItemStack stack, boolean matchDurability) {
        this(stack, matchDurability, true, ItemStackUtils.EMPTY, Math.min(stack.getCount(), stack.getMaxStackSize()), Math.min(stack.getCount(), stack.getMaxStackSize()));
    }

    public MinimumStack(@NotNull ItemStack stack, int count, int minCount) {
        this(stack, count, minCount, true);
    }

    public MinimumStack(@NotNull ItemStorage itemStorage) {
        this(itemStorage.getItemStack(), !itemStorage.ignoreDamageValue(), !itemStorage.ignoreNBT(), ItemStackUtils.EMPTY, itemStorage.getAmount(), itemStorage.getAmount());
    }

    public MinimumStack(@NotNull ItemStack stack, int count, int minCount, boolean matchNBT) {
        this(stack, true, matchNBT, ItemStackUtils.EMPTY, count, minCount);
    }

    public MinimumStack(@NotNull ItemStack stack, boolean matchDamage, boolean matchNBT, @NotNull ItemStack result, int count, int minCount) {
        this(stack, matchDamage, matchNBT, ItemStackUtils.EMPTY, count, minCount, true);
    }

    public MinimumStack(ItemStack stack, boolean matchDamage, boolean matchNBT, ItemStack result, int count, int minCount, boolean canBeResolvedByBuilding) {
        super(stack, matchDamage, matchNBT, result, count, minCount, canBeResolvedByBuilding);
    }

    public static MinimumStack deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag compound) {
        Stack stack = Stack.deserialize(provider, controller, compound);
        return new MinimumStack(stack.getStack(), stack.matchDamage(), stack.matchNBT(), stack.getResult(), stack.getCount(), stack.getMinimumCount(), stack.canBeResolvedByBuilding());
    }

    public static MinimumStack deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
        Stack stack = Stack.deserialize(controller, buffer);
        return new MinimumStack(stack.getStack(), stack.matchDamage(), stack.matchNBT(), stack.getResult(), stack.getCount(), stack.getMinimumCount(), stack.canBeResolvedByBuilding());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MinimumStack)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

