/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.crafting.CountedIngredient;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.minecolonies.api.items.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompostRecipe
implements Recipe<SingleRecipeInput> {
    public static final MapCodec<CompostRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(CompostRecipe::getInput), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("strength", (Object)1).forGetter(CompostRecipe::getStrength)).apply((Applicative)builder, CompostRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CompostRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, CompostRecipe::getInput, (StreamCodec)ByteBufCodecs.VAR_INT, CompostRecipe::getStrength, CompostRecipe::new);
    private static final int FERMENT_TIME = 24000;
    private static final int COMPOST_RESULT = 6;
    private final Ingredient input;
    private final ItemStack output;
    private final int strength;

    public CompostRecipe(@NotNull Ingredient ingredient, int strength) {
        this.input = ingredient;
        this.strength = strength;
        this.output = new ItemStack((ItemLike)ModItems.compost, 6);
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeSerializer.CompostRecipeType.get();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getFermentTime() {
        return 24000;
    }

    public boolean matches(@NotNull SingleRecipeInput input, @NotNull Level worldIn) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput input, @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(@Nullable HolderLookup.Provider provider) {
        return this.output;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializer.CompostRecipeSerializer.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)CountedIngredient.of(this.input, this.calculateIngredientCount()));
        return ingredients;
    }

    private int calculateIngredientCount() {
        return 64 / this.strength;
    }

    @NotNull
    public static CompostRecipe individualize(@NotNull Item item, @NotNull RecipeHolder<CompostRecipe> recipe) {
        return new CompostRecipe(Ingredient.of((ItemLike[])new ItemLike[]{item}), ((CompostRecipe)recipe.value()).getStrength());
    }

    public static class Serializer
    implements RecipeSerializer<CompostRecipe> {
        @NotNull
        public MapCodec<CompostRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CompostRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

