/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.DynamicHappinessSupplier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractHappinessModifier
implements IHappinessModifier {
    private IHappinessSupplierWrapper supplier;
    public String id;
    private double weight;

    public AbstractHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier) {
        this.id = id;
        this.weight = weight;
        this.supplier = supplier;
    }

    @Override
    public double getFactor(@Nullable ICitizenData citizenData) {
        return citizenData == null ? this.supplier.getLastCachedValue() : this.supplier.getValue(citizenData);
    }

    public AbstractHappinessModifier() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, CompoundTag compoundNBT, boolean persist) {
        this.id = compoundNBT.getString("id");
        this.weight = compoundNBT.getDouble("weight");
        CompoundTag supplierCompound = compoundNBT.getCompound("supplier");
        this.supplier = supplierCompound.contains("id") ? new DynamicHappinessSupplier() : new StaticHappinessSupplier();
        this.supplier.deserializeNBT(provider, (Tag)supplierCompound);
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, CompoundTag compoundNBT, boolean persist) {
        compoundNBT.putString("id", this.id);
        compoundNBT.putDouble("weight", this.weight);
        compoundNBT.put("supplier", this.supplier.serializeNBT(provider));
    }

    @Override
    public double getWeight() {
        return this.weight;
    }
}

