/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.AbstractHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public final class ExpirationBasedHappinessModifier
extends AbstractHappinessModifier
implements ITimeBasedHappinessModifier {
    private int days;
    private int period;

    public ExpirationBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, int period) {
        super(id, weight, supplier);
        this.days = period;
        this.period = period;
    }

    public ExpirationBasedHappinessModifier() {
    }

    @Override
    public double getFactor(ICitizenData data) {
        if (this.days > 0 && this.days <= this.period) {
            return super.getFactor(data);
        }
        return 1.0;
    }

    @Override
    public void reset() {
        this.days = this.period;
    }

    @Override
    public void dayEnd(ICitizenData data) {
        if (this.days > 0) {
            --this.days;
        }
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, CompoundTag compoundNBT, boolean persist) {
        super.read(provider, compoundNBT, persist);
        this.days = compoundNBT.getInt("day");
        this.period = compoundNBT.getInt("period");
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, CompoundTag compoundNBT, boolean persist) {
        super.write(provider, compoundNBT, persist);
        compoundNBT.putString("modifier", HappinessRegistry.EXPIRATION_MODIFIER.toString());
        compoundNBT.putInt("day", this.days);
        compoundNBT.putInt("period", this.period);
    }
}

