/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.mobs.drownedpirate;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.RaiderType;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDrownedEntityPirateRaider
extends AbstractEntityMinecoloniesRaider {
    private static final double PIRATE_SWIM_BONUS = 3.0;
    private static final int PIRATE_TEXTURES = 4;
    private int textureId;

    public AbstractDrownedEntityPirateRaider(EntityType<? extends AbstractDrownedEntityPirateRaider> type, Level world) {
        super((EntityType<? extends AbstractEntityMinecoloniesRaider>)type, world, 4);
    }

    @Override
    public void playAmbientSound() {
        if (this.level().random.nextInt(100) <= 1) {
            this.playSound(this.isInWater() ? SoundEvents.DROWNED_AMBIENT_WATER : SoundEvents.DROWNED_AMBIENT, this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public boolean checkSpawnObstruction(LevelReader level) {
        return level.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor worldIn, MobSpawnType spawnReasonIn) {
        return true;
    }

    @Override
    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.navigation = this.newNavigator;
            this.newNavigator.setSwimSpeedFactor(this.getSwimSpeedFactor());
            this.newNavigator.setSpeedModifier(0.5);
            this.newNavigator.getPathingOptions().withStartSwimCost(0.0).withSwimCost(0.0).withDivingCost(0.0).withCanEnterDoors(true).withCanEnterGates(true).withDropCost(0.0).withJumpCost(0.0).withWalkUnderWater(true).withNonLadderClimbableCost(0.0).setPassDanger(true);
            PathingStuckHandler stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.4f).withBuildLeafBridges().withChanceToByPassMovingAway(0.2).withPlaceLadders();
            if (((Boolean)((ServerConfiguration)MinecoloniesAPIProxy.getInstance().getConfig().getServer()).raidersbreakblocks.get()).booleanValue()) {
                stuckHandler.withBlockBreaks();
                stuckHandler.withCompleteStuckBlockBreak(6);
            }
            this.newNavigator.setStuckHandler(stuckHandler);
            this.newNavigator.setCanFloat(true);
        }
        return this.newNavigator;
    }

    @Override
    protected int decreaseAirSupply(int supply) {
        return supply;
    }

    @Override
    public RaiderType getRaiderType() {
        return RaiderType.PIRATE;
    }

    @Override
    public double getSwimSpeedFactor() {
        return 3.0;
    }
}

