/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.items.component;

import com.minecolonies.api.items.component.ModDataComponents;
import com.minecolonies.api.util.constant.Constants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.UnaryOperator;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record SupplyData(boolean sawStory, boolean instantPlacement, long randomKey) {
    public static final SupplyData EMPTY = new SupplyData(false, false, -1L);
    public static final Codec<SupplyData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("sawstory").forGetter(SupplyData::sawStory), (App)Codec.BOOL.fieldOf(Constants.PLACEMENT_NBT).forGetter(SupplyData::instantPlacement), (App)Codec.LONG.fieldOf("randkey").forGetter(SupplyData::randomKey)).apply((Applicative)builder, SupplyData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SupplyData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SupplyData::sawStory, (StreamCodec)ByteBufCodecs.BOOL, SupplyData::instantPlacement, (StreamCodec)ByteBufCodecs.VAR_LONG, SupplyData::randomKey, SupplyData::new);

    public SupplyData withSawStory(boolean sawStory) {
        return new SupplyData(sawStory, this.instantPlacement, this.randomKey);
    }

    public SupplyData withRandomKey(long randomKey) {
        return new SupplyData(this.sawStory, this.instantPlacement, randomKey);
    }

    public boolean hasRandomKey() {
        return this.randomKey != SupplyData.EMPTY.randomKey;
    }

    public void writeToItemStack(ItemStack itemStack) {
        itemStack.set(ModDataComponents.SUPPLY_COMPONENT, (Object)this);
    }

    public static SupplyData readFromItemStack(ItemStack itemStack) {
        return (SupplyData)itemStack.getOrDefault(ModDataComponents.SUPPLY_COMPONENT, (Object)EMPTY);
    }

    public static void updateItemStack(ItemStack itemStack, UnaryOperator<SupplyData> updater) {
        ((SupplyData)updater.apply(SupplyData.readFromItemStack(itemStack))).writeToItemStack(itemStack);
    }
}

