/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.Box;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.citizen.MainWindowCitizen;
import com.minecolonies.core.colony.interactionhandling.QuestDialogueInteraction;
import com.minecolonies.core.network.messages.server.colony.InteractionClose;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WindowInteraction
extends AbstractWindowSkeleton {
    public static final String BUTTON_RESPONSE_ID = "response_";
    private final ICitizenDataView citizen;
    private final List<IInteractionResponseHandler> interactions;
    private int currentInteraction = 0;

    public WindowInteraction(ICitizenDataView citizen) {
        super(new MainWindowCitizen(citizen), new ResourceLocation("minecolonies", "gui/citizen/windowinteraction.xml"));
        this.citizen = citizen;
        this.interactions = new ArrayList<IInteractionResponseHandler>(citizen.getOrderedInteractions());
        this.registerButton("cancel", this::cancelClicked);
    }

    private void cancelClicked() {
        this.close();
    }

    public void onOpened() {
        super.onOpened();
        this.interactions.removeIf(interaction -> !interaction.isVisible((Level)Minecraft.getInstance().level));
        this.setupInteraction();
    }

    private void setupInteraction() {
        if (this.currentInteraction >= this.interactions.size()) {
            this.close();
            return;
        }
        ((ItemIcon)this.window.findPaneOfTypeByID("requestItem", ItemIcon.class)).hide();
        IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
        if (handler.getPriority().getPriority() <= ChatPriority.CHITCHAT.getPriority() && this.currentInteraction > 0 && !(handler instanceof QuestDialogueInteraction)) {
            ++this.currentInteraction;
            this.setupInteraction();
            return;
        }
        handler.onOpened((Player)Minecraft.getInstance().player);
        Box group = (Box)this.findPaneOfTypeByID("responseOptions", Box.class);
        group.getChildren().clear();
        int y = 0;
        int x = 0;
        Text chatText = (Text)this.findPaneOfTypeByID("chat", Text.class);
        chatText.setTextAlignment(Alignment.TOP_LEFT);
        chatText.setAlignment(Alignment.TOP_LEFT);
        chatText.setText(Component.literal((String)(this.citizen.getName() + ": " + handler.getInquiry((Player)Minecraft.getInstance().player).getString())));
        int responseIndex = 1;
        for (Component component : handler.getPossibleResponses()) {
            ButtonImage button = new ButtonImage();
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
            int textLen = this.mc.font.width(component.getString());
            int buttonHeight = 17;
            if (textLen > 125) {
                buttonHeight = 34;
            }
            button.setSize(129, buttonHeight);
            button.setColors(100);
            button.setPosition(x, y);
            button.setID(BUTTON_RESPONSE_ID + responseIndex);
            button.setTextRenderBox(129, buttonHeight);
            button.setTextAlignment(Alignment.TOP_MIDDLE);
            button.setText(component);
            group.addChild((Pane)button);
            button.setTextWrap(true);
            button.setTextScale(Math.min(1.0, 258.0 / (double)textLen));
            if ((x += button.getWidth() + 10) + button.getWidth() >= group.getWidth()) {
                x = 0;
                y += 37;
            }
            ++responseIndex;
        }
        handler.onWindowOpened(this, this.citizen);
    }

    public void onClosed() {
        super.onClosed();
        if (this.currentInteraction < this.interactions.size()) {
            this.interactions.get(this.currentInteraction).onClosed();
            new InteractionClose(this.citizen.getColonyId(), this.citizen.getId(), (ResourceKey<Level>)this.mc.level.dimension(), this.interactions.get(this.currentInteraction).getInquiry()).sendToServer();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("cancel")) {
            super.onButtonClicked(button);
        } else if (!this.interactions.isEmpty()) {
            IInteractionResponseHandler handler = this.interactions.get(this.currentInteraction);
            try {
                if (handler.onClientResponseTriggered(Integer.parseInt(button.getID().replace(BUTTON_RESPONSE_ID, "")) - 1, (Player)Minecraft.getInstance().player, this.citizen, this)) {
                    ++this.currentInteraction;
                    this.setupInteraction();
                    return;
                }
                this.setupInteraction();
            }
            catch (Exception ex) {
                Log.getLogger().warn("Wrong button id of interaction.", (Throwable)ex);
            }
        }
    }
}

