/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.plantation.IPlantationModule;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.tileentities.AbstractTileEntityPlantationField;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowBuildDecoration;
import com.minecolonies.core.network.messages.server.PlantationFieldBuildRequestMessage;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowPlantationField
extends AbstractWindowSkeleton {
    private static final String NOT_IN_COLONY_TEXT_ID = "not-in-colony";
    private static final String PLANTS_HEADER_TEXT_ID = "plants-header";
    private static final String LIST_PLANTS_ID = "plants";
    private static final String LIST_PLANTS_ICON_ID = "icon";
    private static final String BUTTON_REPAIR_ID = "repair";
    private static final double LIST_PLANTS_COLUMN_COUNT = 4.0;
    private final AbstractTileEntityPlantationField tileEntityPlantationField;
    private final List<ItemStack> plants;

    public WindowPlantationField(AbstractTileEntityPlantationField tileEntityPlantationField) {
        super(new ResourceLocation("minecolonies", "gui/windowplantationfield.xml"));
        this.tileEntityPlantationField = tileEntityPlantationField;
        this.plants = tileEntityPlantationField.getPlantationFieldTypes().stream().flatMap(f -> f.getExtensionModuleProducers().stream().map(m -> (IBuildingExtensionModule)m.apply(null)).filter(IPlantationModule.class::isInstance).map(m -> (IPlantationModule)m)).map(fieldType -> new ItemStack((ItemLike)fieldType.getItem())).toList();
        this.registerButton(BUTTON_REPAIR_ID, this::repairField);
        this.updateElementStates();
    }

    private void repairField() {
        this.close();
        new WindowBuildDecoration(this.tileEntityPlantationField.getBlockPos(), this.tileEntityPlantationField.getPackName(), this.tileEntityPlantationField.getBlueprintPath(), this.tileEntityPlantationField.getRotationMirror(), builder -> new PlantationFieldBuildRequestMessage(WorkOrderType.REPAIR, this.tileEntityPlantationField.getBlockPos(), this.tileEntityPlantationField.getPackName(), this.tileEntityPlantationField.getBlueprintPath(), (ResourceKey<Level>)Minecraft.getInstance().level.dimension(), this.tileEntityPlantationField.getRotationMirror(), (BlockPos)builder)).open();
    }

    private void updateElementStates() {
        IColonyView colonyView = this.getCurrentColony();
        ((Text)this.findPaneOfTypeByID(NOT_IN_COLONY_TEXT_ID, Text.class)).setVisible(colonyView == null);
        ((Text)this.findPaneOfTypeByID(PLANTS_HEADER_TEXT_ID, Text.class)).setVisible(colonyView != null);
        ((ScrollingList)this.findPaneOfTypeByID(LIST_PLANTS_ID, ScrollingList.class)).setVisible(colonyView != null);
        ((ButtonImage)this.findPaneOfTypeByID(BUTTON_REPAIR_ID, ButtonImage.class)).setVisible(colonyView != null);
    }

    @Nullable
    private IColonyView getCurrentColony() {
        IColony iColony = this.tileEntityPlantationField.getCurrentColony();
        if (iColony instanceof IColonyView) {
            IColonyView colonyView = (IColonyView)iColony;
            return colonyView;
        }
        return null;
    }

    public void onUpdate() {
        super.onUpdate();
        this.updateElementStates();
    }

    public void onOpened() {
        super.onOpened();
        ScrollingList fieldList = (ScrollingList)this.findPaneOfTypeByID(LIST_PLANTS_ID, ScrollingList.class);
        fieldList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return (int)Math.ceil((double)WindowPlantationField.this.plants.size() / 4.0);
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int id = 1;
                while ((double)id <= 4.0) {
                    ItemIcon pane = (ItemIcon)rowPane.findPaneOfTypeByID(WindowPlantationField.LIST_PLANTS_ICON_ID + id, ItemIcon.class);
                    Box parent = (Box)pane.getParent();
                    parent.setLineWidth(0);
                    int itemIndex = (index + 1) * id - 1;
                    if (itemIndex < WindowPlantationField.this.plants.size()) {
                        pane.setItem(WindowPlantationField.this.plants.get(itemIndex));
                        parent.setLineWidth(1);
                    }
                    ++id;
                }
            }
        });
    }
}

