/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.map;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.views.Box;
import com.ldtteam.blockui.views.View;
import com.ldtteam.blockui.views.ZoomDragView;
import com.minecolonies.api.client.render.modeltype.ISimpleModelType;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IStackBasedTask;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.map.ColonySize;
import com.minecolonies.core.client.gui.map.MinecraftMap;
import com.minecolonies.core.client.gui.questlog.Constants;
import com.minecolonies.core.client.render.worldevent.HighlightManager;
import com.minecolonies.core.client.render.worldevent.highlightmanager.CitizenRenderData;
import com.minecolonies.core.colony.buildings.views.LivingBuildingView;
import com.minecolonies.core.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.colony.ColonyListMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.mojang.authlib.GameProfile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;

public class WindowColonyMap
extends AbstractWindowSkeleton {
    public static final int HIGHLIGHT_RANGE = 2;
    public static final int STATUS_ICON_SIZE = 6;
    private static final int MAP_ZOOM = 2;
    private static final int MAP_SIZE = 256;
    private static final double COLONY_DETAIL_SCALE = 0.3;
    private static List<ColonyListMessage.ColonyInfo> colonies = new ArrayList<ColonyListMessage.ColonyInfo>();
    private final BlockPos playerPos;
    private final ZoomDragView dragView;
    private final boolean atTownHall;
    private Map<ICitizenDataView, View> citizens = new HashMap<ICitizenDataView, View>();
    private Map<IBuildingView, MapDecoration> buildings = new HashMap<IBuildingView, MapDecoration>();
    private Map<ColonyListMessage.ColonyInfo, View> coloniesImages = new HashMap<ColonyListMessage.ColonyInfo, View>();
    private List<MinecraftMap> maps = new ArrayList<MinecraftMap>();
    private ITownHallView building;
    private final DecimalFormat scaleformet = new DecimalFormat("##");
    private double currentScale = 0.0;
    private final boolean hasMaps;
    private final BlockPos worldPosRoot;

    public WindowColonyMap(boolean atTownHall, ITownHallView building) {
        super(new ResourceLocation("minecolonies", "gui/map/windowcolonymap.xml"));
        this.atTownHall = atTownHall;
        this.building = building;
        this.playerPos = Minecraft.getInstance().player.blockPosition();
        this.dragView = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        this.hasMaps = !building.getMapDataList().isEmpty();
        this.findPaneByID("warning").setVisible(!this.hasMaps);
        if (this.hasMaps) {
            int minX = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxScale = 0;
            for (ITownHallView.MapEntry entry : building.getMapDataList()) {
                int scale = 1 << entry.mapData().scale;
                maxScale = Math.max(maxScale, scale);
                minX = Math.min(minX, entry.mapData().centerX - 64 * scale);
                maxX = Math.max(maxX, entry.mapData().centerX + 64 * scale);
                minZ = Math.min(minZ, entry.mapData().centerZ - 64 * scale);
                maxZ = Math.max(maxZ, entry.mapData().centerZ + 64 * scale);
            }
            this.worldPosRoot = new BlockPos(minX - 256 * maxScale, 0, minZ - 256 * maxScale);
            this.addMaps();
            MinecraftMap bottomRightFake = new MinecraftMap();
            bottomRightFake.setSize(256 * maxScale, 256 * maxScale);
            bottomRightFake.setID("mapBottomRight" + maxX + "-" + maxZ);
            this.putPaneTopLeftCornerAtWorldPos(bottomRightFake, new BlockPos(maxX, 0, maxZ));
            this.dragView.addChild((Pane)bottomRightFake);
            this.addCitizens(building.getColony());
            this.addCenterPos();
        } else {
            this.worldPosRoot = null;
        }
        if (atTownHall) {
            this.registerButton("exit", () -> building.openGui(false));
        } else {
            this.findPaneByID("inventory").hide();
            this.registerButton("exit", this::close);
        }
        this.registerButton("inventory", this::inventoryClicked);
        new ColonyListMessage().sendToServer();
    }

    private void inventoryClicked() {
        new OpenInventoryMessage(this.building).sendToServer();
    }

    private void addMaps() {
        for (ITownHallView.MapEntry mapEntry : this.building.getMapDataList()) {
            MapItemSavedData mapData = mapEntry.mapData();
            int scale = 1 << mapData.scale;
            MinecraftMap mapImage = new MinecraftMap();
            this.putPaneTopLeftCornerAtWorldPos(mapImage, new BlockPos(mapData.centerX - 64 * scale, 0, mapData.centerZ - 64 * scale));
            mapImage.setID("map" + mapData.centerX + "-" + mapData.centerZ);
            mapImage.setMapData(mapEntry.mapId(), mapData);
            mapImage.setSize(256 * scale, 256 * scale);
            this.dragView.addChild((Pane)mapImage);
        }
    }

    public static void setColonies(List<ColonyListMessage.ColonyInfo> colonyInfo) {
        colonies = colonyInfo;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.hasMaps) {
            for (Map.Entry<ICitizenDataView, View> entry : this.citizens.entrySet()) {
                EntityCitizen citizen = (EntityCitizen)this.building.getColony().getWorld().getEntity(entry.getKey().getEntityId());
                if (citizen == null) continue;
                this.putPaneCenterAtWorldPos((Pane)entry.getValue(), citizen.blockPosition());
            }
            for (Map.Entry<Object, Object> entry : this.buildings.entrySet()) {
                if (((MapDecoration)entry.getValue()).rangeBox == null) continue;
                if (((MapDecoration)entry.getValue()).icon.wasCursorInPane()) {
                    ((MapDecoration)entry.getValue()).rangeBox.show();
                    continue;
                }
                ((MapDecoration)entry.getValue()).rangeBox.hide();
            }
            for (Player player : Minecraft.getInstance().level.players()) {
                if (!this.building.getColony().isCoordInColony((Level)Minecraft.getInstance().level, player.blockPosition())) continue;
                Image playerImage = (Image)this.findPaneOfTypeByID(player.getStringUUID(), Image.class);
                if (playerImage == null) {
                    ResourceLocation resourceLocation = Minecraft.getInstance().getSkinManager().getInsecureSkin(player.getGameProfile()).texture();
                    if (resourceLocation == null) continue;
                    OutOfJarResourceLocation.ofMinecraftSkin((Minecraft)Minecraft.getInstance(), (GameProfile)player.getGameProfile(), PlayerSkin::texture).thenAccept(resLoc -> {
                        if (resLoc != null) {
                            Image localPlayerImage = new Image();
                            localPlayerImage.setID(player.getStringUUID());
                            localPlayerImage.setSize(16, 16);
                            localPlayerImage.setImage(resLoc, 8, 8, 8, 8);
                            this.dragView.addChild((Pane)localPlayerImage);
                            ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)localPlayerImage).append(Component.literal((String)player.getDisplayName().getString()))).build();
                        }
                    });
                    continue;
                }
                this.putPaneCenterAtWorldPos((Pane)playerImage, player.blockPosition());
            }
            if (this.currentScale != this.dragView.getScale()) {
                this.currentScale = this.dragView.getScale();
                this.updateScale();
            }
        }
    }

    private void updateScale() {
        for (ColonyListMessage.ColonyInfo colonyInfo : colonies) {
            this.updateColonyInfoImage(colonyInfo);
        }
        for (IBuildingView iBuildingView : this.building.getColony().getBuildings()) {
            this.updateBuildingView(iBuildingView);
        }
        if (this.currentScale < 0.3) {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((MapDecoration)entry.getValue()).icon.off();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((View)entry.getValue()).off();
            }
        } else {
            for (Map.Entry entry : this.buildings.entrySet()) {
                ((MapDecoration)entry.getValue()).icon.on();
            }
            for (Map.Entry entry : this.citizens.entrySet()) {
                ((View)entry.getValue()).on();
            }
            for (Map.Entry entry : this.coloniesImages.entrySet()) {
                ((View)entry.getValue()).off();
            }
        }
        ((Text)this.findPaneOfTypeByID("scale", Text.class)).setText(Component.literal((String)(this.scaleformet.format(1.0 / this.currentScale) + "x")));
    }

    private void updateColonyInfoImage(ColonyListMessage.ColonyInfo colonyInfo) {
        View colonyPane = this.coloniesImages.get(colonyInfo);
        if (colonyPane == null) {
            colonyPane = ColonySize.createViewForInfo(colonyInfo);
            colonyPane.setID(colonyInfo.getId() + colonyInfo.getOwner());
            this.dragView.addChild((Pane)colonyPane);
            this.coloniesImages.put(colonyInfo, colonyPane);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)colonyPane).append(Component.literal((String)("Owner:" + colonyInfo.getOwner())))).appendNL(Component.literal((String)("Coordinates: " + colonyInfo.getCenter().getX() + "X, " + colonyInfo.getCenter().getZ() + "Z")))).appendNL(Component.literal((String)("Citizens: " + colonyInfo.getCitizencount())))).build();
        }
        if (this.currentScale < 0.3) {
            this.putPaneCenterAtWorldPos((Pane)colonyPane, colonyInfo.getCenter());
            colonyPane.on();
        } else {
            colonyPane.off();
        }
    }

    private void addCenterPos() {
        Image citizenImage = new Image();
        citizenImage.setImage(new ResourceLocation("minecolonies", "textures/gui/red_wax_home.png"), false);
        citizenImage.setSize(16, 16);
        this.putPaneTopLeftCornerAtWorldPos((Pane)citizenImage, this.playerPos);
        this.dragView.setScaleRaw(0.8);
        this.dragView.setScrollX(this.dragView.calcInverseAbsoluteX((double)citizenImage.getX()) - (double)(this.dragView.getWidth() / 2));
        this.dragView.setScrollY(this.dragView.calcInverseAbsoluteY((double)citizenImage.getY()) - (double)(this.dragView.getHeight() / 2));
        this.putPaneCenterAtWorldPos((Pane)citizenImage, this.playerPos);
        this.dragView.addChild((Pane)citizenImage);
        if (!this.atTownHall) {
            citizenImage.hide();
        }
    }

    private void updateBuildingView(IBuildingView buildingView) {
        MapDecoration buildingDecorations = this.buildings.get(buildingView);
        if (buildingDecorations == null) {
            LivingBuildingView home;
            int n;
            Object home2;
            ItemIcon uiBuilding = new ItemIcon();
            Box box = null;
            Box houseWithCapacity = null;
            Image statusImage = null;
            uiBuilding.setID(buildingView.getID().toShortString());
            uiBuilding.setSize(11 + buildingView.getBuildingLevel(), 11 + buildingView.getBuildingLevel());
            ItemStack item = buildingView.getBuildingType().getBuildingBlock().asItem().getDefaultInstance();
            uiBuilding.setItem(item);
            this.dragView.addChild((Pane)uiBuilding);
            AbstractTextBuilder.TooltipBuilder tooltip = PaneBuilders.tooltipBuilder();
            AbstractTextBuilder.TooltipBuilder tooltipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)tooltip.hoverPane((Pane)uiBuilding).append(Component.translatable((String)buildingView.getBuildingDisplayName()))).append(Component.literal((String)(" : " + buildingView.getBuildingLevel())))).appendNL(Component.literal((String)("Coordinates: " + buildingView.getID().getX() + "X, " + buildingView.getID().getZ() + "Z")));
            if (buildingView instanceof LivingBuildingView) {
                home2 = (LivingBuildingView)buildingView;
                n = ((LivingBuildingView)home2).getResidents().size();
            } else {
                n = buildingView.getAllAssignedCitizens().size();
            }
            tooltipBuilder.appendNL(Component.literal((String)("Citizens: " + n)));
            home2 = buildingView.getAllAssignedCitizens().iterator();
            while (home2.hasNext()) {
                int id = (Integer)home2.next();
                ICitizenDataView dataView = this.building.getColony().getCitizen(id);
                if (dataView == null) continue;
                tooltip.appendNL(Component.literal((String)dataView.getName()));
            }
            ImmutableList<IRequest<?>> playerResolvedRequests = this.getPlayerResolvedRequestsForBuilding(buildingView);
            if (playerResolvedRequests.size() > 0) {
                statusImage = new Image();
                statusImage.setImage(ResourceLocation.fromNamespaceAndPath((String)"minecolonies", (String)"textures/icons/information.png"), false);
                statusImage.setSize(6, 6);
                BlockPos uiPos = this.worldPosToUIPos(buildingView.getPosition());
                statusImage.setPosition(uiPos.getX() - uiBuilding.getWidth() / 2, uiPos.getY() - uiBuilding.getHeight() / 2);
                statusImage.setVisible(true);
                AbstractTextBuilder.TooltipBuilder statustip = PaneBuilders.tooltipBuilder();
                statustip.hoverPane((Pane)statusImage);
                statustip.append(Component.translatable((String)"com.minecolonies.core.item.colonymap.playerresolvedrequests"));
                for (IRequest request : playerResolvedRequests) {
                    int count = -1;
                    MutableComponent tipText = null;
                    if (request instanceof IStackBasedTask) {
                        IStackBasedTask stackRequest = (IStackBasedTask)((Object)request);
                        count = stackRequest.getDisplayCount();
                        tipText = stackRequest.getDisplayPrefix();
                    } else {
                        tipText = Component.literal((String)request.getLongDisplayString().getString().replace("\u00a7f", ""));
                    }
                    statustip.appendNL((Component)tipText);
                    if (count <= 0) continue;
                    statustip.append(Component.literal((String)(": " + count)));
                }
                this.dragView.addChild((Pane)statusImage);
                statustip.build();
                tooltip.appendNL(Component.translatable((String)"com.minecolonies.core.item.colonymap.playerresolvedrequests.count", (Object[])new Object[]{playerResolvedRequests.size()}));
            }
            tooltip.build();
            uiBuilding.setVisible(true);
            if (buildingView instanceof LivingBuildingView && (home = (LivingBuildingView)buildingView).getResidents().size() < buildingView.getBuildingLevel() && buildingView.getRange() == 0) {
                double pctFull = Math.max(0.0, Math.min(1.0, (double)home.getResidents().size() / (double)buildingView.getBuildingLevel()));
                houseWithCapacity = new Box();
                BlockPos uiPos = this.worldPosToUIPos(buildingView.getPosition());
                houseWithCapacity.setLineWidth(2);
                houseWithCapacity.setColor(MapDecoration.getRedFromRange(pctFull), MapDecoration.getGreenFromRange(pctFull), 33);
                houseWithCapacity.setPosition(uiPos.getX(), uiPos.getZ());
                houseWithCapacity.setSize(uiBuilding.getWidth(), uiBuilding.getHeight());
                this.dragView.addChild((Pane)houseWithCapacity);
            }
            if (buildingView.getRange() != 0) {
                box = new Box();
                box.setLineWidth(2);
                box.setColor(255, 0, 0);
                box.hide();
                this.dragView.addChild((Pane)box);
            }
            this.dragView.addChild((Pane)uiBuilding);
            buildingDecorations = new MapDecoration(this, uiBuilding, box, houseWithCapacity, statusImage);
            this.buildings.put(buildingView, buildingDecorations);
        }
        BlockPos newPos = this.worldPosToUIPos(buildingView.getID());
        buildingDecorations.icon.setPosition(newPos.getX(), newPos.getZ());
        this.putPaneCenterAtWorldPos((Pane)buildingDecorations.icon, buildingView.getID());
        if (buildingDecorations.rangeBox != null) {
            int range = buildingView.getRange();
            BlockPos UIPos1 = this.worldPosToUIPos(buildingView.getPosition().offset(-range, 0, -range));
            BlockPos UIPos2 = this.worldPosToUIPos(buildingView.getPosition().offset(range, 0, range));
            buildingDecorations.rangeBox.setPosition(UIPos1.getX(), UIPos1.getZ());
            buildingDecorations.rangeBox.setSize(UIPos2.getX() - UIPos1.getX(), UIPos2.getZ() - UIPos1.getZ());
        }
        if (buildingDecorations.highlightBox != null) {
            buildingDecorations.highlightBox.setSize(buildingDecorations.icon.getWidth(), buildingDecorations.icon.getHeight());
            this.putPaneCenterAtWorldPos((Pane)buildingDecorations.highlightBox, buildingView.getPosition());
        }
        if (buildingDecorations.statusImage != null) {
            this.applyWorldPosToPane((Pane)buildingDecorations.statusImage, buildingView.getPosition(), -((buildingDecorations.icon.getWidth() + buildingDecorations.statusImage.getWidth()) / 2), -((buildingDecorations.icon.getHeight() + buildingDecorations.statusImage.getHeight()) / 2));
        }
    }

    private void addCitizens(IColonyView colony) {
        for (ICitizenDataView data : colony.getCitizens().values()) {
            EntityCitizen citizen = (EntityCitizen)colony.getWorld().getEntity(data.getEntityId());
            if (citizen == null) continue;
            View citizenView = new View();
            this.putPaneCenterAtWorldPos((Pane)citizenView, citizen.blockPosition());
            ButtonImage citizenImage = new ButtonImage();
            citizenImage.setImage(((ISimpleModelType)IModelTypeRegistry.getInstance().getModelType(citizen.getModelType())).getTextureIcon(citizen));
            citizenImage.setSize(4, 4);
            citizenImage.setID("citizen: " + data.getId());
            this.registerButton(citizenImage.getID(), (Button button) -> {
                HighlightManager.addHighlight("mapsearchtracking", "", new CitizenRenderData(citizen.getCivilianID(), Constants.HIGHLIGHT_QUEST_LOG_TRACKER_DURATION));
                SoundUtils.playSuccessSound((Player)this.mc.player, this.mc.player.blockPosition());
            });
            AbstractTextBuilder.TooltipBuilder builder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)citizenView).paragraphBreak()).append(citizen.getDisplayName());
            if (!data.getJob().isEmpty()) {
                citizenImage.setSize(8, 8);
                ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(Component.translatableEscape((String)"com.minecolonies.coremod.gui.citizen.job.label", (Object[])new Object[]{Component.translatable((String)data.getJob())}));
            }
            citizenView.setSize(citizenImage.getWidth(), citizenImage.getHeight());
            citizenView.addChild((Pane)citizenImage);
            this.dragView.addChild((Pane)citizenView);
            if (data.hasVisibleStatus()) {
                Image interactionImage = new Image();
                interactionImage.setImage(data.getStatusIcon(), false);
                interactionImage.setSize(6, 6);
                interactionImage.setPosition(-3, -3);
                citizenView.addChild((Pane)interactionImage);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
                if (data.hasBlockingInteractions()) {
                    MutableComponent inquiry = (MutableComponent)data.getOrderedInteractions().get(0).getInquiry();
                    ((AbstractTextBuilder.TooltipBuilder)builder.newLine()).append(inquiry.withStyle(ChatFormatting.DARK_RED));
                }
            }
            if (data.isSick()) {
                Image sickIcon = new Image();
                sickIcon.setImage(new ResourceLocation("minecolonies", "textures/icons/small_sick_icon.png"), false);
                sickIcon.setSize(4, 8);
                sickIcon.setPosition(3, -3);
                citizenView.addChild((Pane)sickIcon);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            } else if (data.getSaturation() < 6.0) {
                @NotNull Image saturationIcon = new Image();
                saturationIcon.setImage(ResourceLocation.withDefaultNamespace((String)"hud/food_empty"), false);
                saturationIcon.setSize(9, 9);
                saturationIcon.setSize(9, 9);
                saturationIcon.setPosition(3, -3);
                citizenView.addChild((Pane)saturationIcon);
                citizenView.setSize(citizenView.getWidth() + 6, citizenView.getHeight() + 6);
            }
            ((AbstractTextBuilder.TooltipBuilder)builder.color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            if (this.citizens.containsKey(data)) {
                this.dragView.removeChild((Pane)this.citizens.get(data));
            }
            this.citizens.put(data, citizenView);
        }
    }

    private void putPaneTopLeftCornerAtWorldPos(Pane pane, BlockPos worldPos) {
        this.applyWorldPosToPane(pane, worldPos, 0, 0);
    }

    private void putPaneCenterAtWorldPos(Pane pane, BlockPos worldPos) {
        this.applyWorldPosToPane(pane, worldPos, -pane.getWidth() / 2, -pane.getHeight() / 2);
    }

    private void applyWorldPosToPane(Pane pane, BlockPos worldPos, int offsetUiX, int offsetUiZ) {
        int x = worldPos.getX() - this.worldPosRoot.getX();
        int z = worldPos.getZ() - this.worldPosRoot.getZ();
        x *= 2;
        z *= 2;
        pane.setPosition(x += offsetUiX, z += offsetUiZ);
    }

    private BlockPos worldPosToUIPos(BlockPos worldPos) {
        int x = worldPos.getX() - this.worldPosRoot.getX();
        int z = worldPos.getZ() - this.worldPosRoot.getZ();
        return new BlockPos(x *= 2, worldPos.getY(), z *= 2);
    }

    public ImmutableList<IRequest<?>> getPlayerResolvedRequestsForBuilding(IBuildingView buildingView) {
        if (buildingView == null || buildingView.getColony() == null) {
            return ImmutableList.of();
        }
        StaticLocation buildingLocation = new StaticLocation(buildingView.getPosition(), buildingView.getColony().getDimension());
        ArrayList playerResolvedBuildingRequests = Lists.newArrayList();
        if (buildingView == null || buildingView.getColony() == null) {
            return ImmutableList.of();
        }
        IRequestManager requestManager = buildingView.getColony().getRequestManager();
        if (requestManager == null) {
            return ImmutableList.of();
        }
        try {
            IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
            HashSet assigned = new HashSet((Collection<IToken<?>>)resolver.getAllAssignedRequests());
            for (IToken iToken : assigned) {
                IRequest<?> r = requestManager.getRequestForToken(iToken);
                if (r == null || !r.getRequester().getLocation().equals(buildingLocation)) continue;
                playerResolvedBuildingRequests.add(r);
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Exception trying to retrieve requests:", (Throwable)e);
            requestManager.reset();
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)playerResolvedBuildingRequests);
    }

    public class MapDecoration {
        public ItemIcon icon;
        public Box rangeBox;
        public Box highlightBox;
        public Image statusImage;

        public MapDecoration(WindowColonyMap this$0, ItemIcon icon, Box rangeBox, Box highlightBox, Image statusImage) {
            this.icon = icon;
            this.rangeBox = rangeBox;
            this.highlightBox = highlightBox;
            this.statusImage = statusImage;
        }

        public static int getRedFromRange(double pctFull) {
            int red = pctFull <= 0.5 ? (int)(255.0 * (pctFull / 0.5)) : 255;
            return red;
        }

        public static int getGreenFromRange(double pctFull) {
            int green = pctFull <= 0.5 ? 255 : (int)(255.0 * (1.0 - (pctFull - 0.5) / 0.5));
            return green;
        }
    }
}

