/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.GraveyardManagementModuleView;
import com.minecolonies.core.tileentities.TileEntityGrave;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GraveyardManagementWindow
extends AbstractModuleWindow<GraveyardManagementModuleView> {
    private static final String LIST_GRAVES = "graves";
    private static final String LIST_CITIZEN = "citizen";
    private static final String TAG_NAME = "name";
    private static final String TAG_CITIZEN_NAME = "citizenName";
    private static final String TAG_DISTANCE = "dist";
    private static final String TAG_DIRECTION = "dir";
    private final ClientLevel world;

    public GraveyardManagementWindow(GraveyardManagementModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutgraveyard.xml"));
        this.world = Minecraft.getInstance().level;
    }

    public void onOpened() {
        super.onOpened();
        ScrollingList graveList = (ScrollingList)this.findPaneOfTypeByID(LIST_GRAVES, ScrollingList.class);
        graveList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((GraveyardManagementModuleView)GraveyardManagementWindow.this.moduleView).getGraves().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                BlockPos grave = ((GraveyardManagementModuleView)GraveyardManagementWindow.this.moduleView).getGraves().get(index);
                @NotNull String distance = Integer.toString((int)Math.sqrt(BlockPosUtil.getDistanceSquared(grave, GraveyardManagementWindow.this.buildingView.getPosition())));
                Component direction = BlockPosUtil.calcDirection(GraveyardManagementWindow.this.buildingView.getPosition(), grave).getLongText();
                BlockEntity entity = GraveyardManagementWindow.this.world.getBlockEntity(grave);
                if (entity instanceof TileEntityGrave) {
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_NAME, Text.class)).setText(Component.literal((String)("Grave of " + (((TileEntityGrave)entity).getGraveData() != null ? ((TileEntityGrave)entity).getGraveData().getCitizenName() : "Unknown Citizen"))));
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_DISTANCE, Text.class)).setText(Component.literal((String)(distance + "m")));
                    ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_DIRECTION, Text.class)).setText(direction);
                }
            }
        });
        ScrollingList ripList = (ScrollingList)this.findPaneOfTypeByID(LIST_CITIZEN, ScrollingList.class);
        ripList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((GraveyardManagementModuleView)GraveyardManagementWindow.this.moduleView).getRestingCitizen().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                String citizenName = ((GraveyardManagementModuleView)GraveyardManagementWindow.this.moduleView).getRestingCitizen().get(index);
                ((Text)rowPane.findPaneOfTypeByID(GraveyardManagementWindow.TAG_CITIZEN_NAME, Text.class)).setText(Component.literal((String)citizenName));
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        ((GraveyardManagementModuleView)this.moduleView).cleanGraves();
    }
}

