/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModuleView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowSelectRes;
import com.minecolonies.core.network.messages.server.colony.building.AddMinimumStockToBuildingModuleMessage;
import com.minecolonies.core.network.messages.server.colony.building.RemoveMinimumStockFromBuildingModuleMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MinimumStockModuleWindow
extends AbstractModuleWindow<IMinimumStockModuleView> {
    private static final String LABEL_LIMIT_REACHED = "com.minecolonies.coremod.gui.warehouse.limitreached";
    private final ScrollingList resourceList;

    public MinimumStockModuleWindow(IMinimumStockModuleView moduleView) {
        this(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutminimumstock.xml"));
    }

    public MinimumStockModuleWindow(IMinimumStockModuleView moduleView, ResourceLocation layoutId) {
        super(moduleView, layoutId);
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resourcesstock", ScrollingList.class);
        this.registerButton("addStock", this::addStock);
        if (moduleView.hasReachedLimit()) {
            ButtonImage button = (ButtonImage)this.findPaneOfTypeByID("addStock", ButtonImage.class);
            button.setText(Component.translatableEscape((String)LABEL_LIMIT_REACHED, (Object[])new Object[0]));
            button.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_disabled.png"));
        }
        this.registerButton("removeStock", this::removeStock);
    }

    private void removeStock(Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        Tuple<ItemStorage, Integer> tuple = ((IMinimumStockModuleView)this.moduleView).getStock().get(row);
        ((IMinimumStockModuleView)this.moduleView).getStock().remove(row);
        new RemoveMinimumStockFromBuildingModuleMessage(this.buildingView, tuple.getA().getItemStack(), ((IMinimumStockModuleView)this.moduleView).getProducer().getRuntimeID()).sendToServer();
        this.updateStockList();
    }

    private void addStock() {
        if (!((IMinimumStockModuleView)this.moduleView).hasReachedLimit()) {
            new WindowSelectRes(this, stack -> true, (stack, qty) -> new AddMinimumStockToBuildingModuleMessage(this.buildingView, (ItemStack)stack, (int)qty).sendToServer(), true).open();
        }
    }

    public void onOpened() {
        super.onOpened();
        this.updateStockList();
    }

    private void updateStockList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((IMinimumStockModuleView)MinimumStockModuleWindow.this.moduleView).getStock().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = ((IMinimumStockModuleView)MinimumStockModuleWindow.this.moduleView).getStock().get(index).getA().getItemStack().copy();
                resource.setCount(resource.getMaxStackSize());
                ((Text)rowPane.findPaneOfTypeByID("resourceName", Text.class)).setText(resource.getHoverName());
                ((Text)rowPane.findPaneOfTypeByID("resourceQty", Text.class)).setText(Component.literal((String)String.valueOf(((IMinimumStockModuleView)MinimumStockModuleWindow.this.moduleView).getStock().get(index).getB())));
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }
}

