/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.connections.ColonyConnection;
import com.minecolonies.api.colony.connections.ConnectionEvent;
import com.minecolonies.api.colony.connections.ConnectionEventType;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.network.messages.server.colony.TriggerConnectionEventMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class WindowAlliancePage
extends AbstractWindowTownHall {
    private static final String REQUEST_ALLY = "requestally";
    private static final String START_FEUD = "startfeud";
    private static final String SET_NEUTRAL = "setneutral";
    private static final String ACCEPT_ALLY = "acceptally";
    private static final String LIST_DIRECT = "directcolonylist";
    private static final String LIST_INDIRECT = "indirectcolonylist";
    private static final String LIST_EVENTS = "connectioneventlist";
    private final ScrollingList directConnections = (ScrollingList)this.findPaneOfTypeByID("directcolonylist", ScrollingList.class);
    private final ScrollingList indirectConnections = (ScrollingList)this.findPaneOfTypeByID("indirectcolonylist", ScrollingList.class);
    private final ScrollingList connectionEvents = (ScrollingList)this.findPaneOfTypeByID("connectioneventlist", ScrollingList.class);
    private List<ColonyConnection> directConnectionData;
    private List<ColonyConnection> indirectConnectionData;

    public WindowAlliancePage(BuildingTownHall.View building) {
        super(building, "layoutalliance.xml");
        this.directConnectionData = new ArrayList<ColonyConnection>(building.getColony().getConnectionManager().getDirectlyConnectedColonies().values());
        this.indirectConnectionData = new ArrayList<ColonyConnection>(building.getColony().getConnectionManager().getIndirectlyConnectedColonies().values());
        this.registerButton(REQUEST_ALLY, this::requestAlly);
        this.registerButton(START_FEUD, this::startFeud);
        this.registerButton(SET_NEUTRAL, this::setNeutral);
        this.registerButton(ACCEPT_ALLY, this::acceptAlly);
        this.updateConnections(this.directConnections, this.directConnectionData);
        this.updateConnections(this.indirectConnections, this.indirectConnectionData);
        this.updateEvents();
    }

    private void setNeutral(@NotNull Button button) {
        ColonyConnection connectedColonyData = this.getColonyDataFromPane(button);
        new TriggerConnectionEventMessage(((ITownHallView)this.buildingView).getColony(), new ConnectionEvent(((ITownHallView)this.buildingView).getColony().getID(), ((ITownHallView)this.buildingView).getColony().getName(), ConnectionEventType.NEUTRAL_SET), connectedColonyData.id).sendToServer();
    }

    private void startFeud(@NotNull Button button) {
        ColonyConnection connectedColonyData = this.getColonyDataFromPane(button);
        new TriggerConnectionEventMessage(((ITownHallView)this.buildingView).getColony(), new ConnectionEvent(((ITownHallView)this.buildingView).getColony().getID(), ((ITownHallView)this.buildingView).getColony().getName(), ConnectionEventType.FEUD_STARTED), connectedColonyData.id).sendToServer();
    }

    private void requestAlly(@NotNull Button button) {
        ColonyConnection connectedColonyData = this.getColonyDataFromPane(button);
        new TriggerConnectionEventMessage(((ITownHallView)this.buildingView).getColony(), new ConnectionEvent(((ITownHallView)this.buildingView).getColony().getID(), ((ITownHallView)this.buildingView).getColony().getName(), ConnectionEventType.ALLY_REQUEST), connectedColonyData.id).sendToServer();
    }

    private void acceptAlly(@NotNull Button button) {
        List<ConnectionEvent> list = ((ITownHallView)this.buildingView).getColony().getConnectionManager().getConnectionEvents();
        int revIndex = list.size() - 1 - this.connectionEvents.getListElementIndexByPane((Pane)button);
        new TriggerConnectionEventMessage(((ITownHallView)this.buildingView).getColony(), new ConnectionEvent(((ITownHallView)this.buildingView).getColony().getID(), ((ITownHallView)this.buildingView).getColony().getName(), ConnectionEventType.ALLY_CONFIRMED), list.get(revIndex).id()).sendToServer();
    }

    private ColonyConnection getColonyDataFromPane(@NotNull Button button) {
        int directRow = this.directConnections.getListElementIndexByPane((Pane)button);
        if (directRow != -1) {
            return this.directConnectionData.get(directRow);
        }
        int indirectRow = this.indirectConnections.getListElementIndexByPane((Pane)button);
        return this.indirectConnectionData.get(indirectRow);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.directConnectionData = new ArrayList<ColonyConnection>(((ITownHallView)this.buildingView).getColony().getConnectionManager().getDirectlyConnectedColonies().values());
        this.indirectConnectionData = new ArrayList<ColonyConnection>(((ITownHallView)this.buildingView).getColony().getConnectionManager().getIndirectlyConnectedColonies().values());
        this.updateConnections(this.directConnections, this.directConnectionData);
        this.updateConnections(this.indirectConnections, this.indirectConnectionData);
        this.updateEvents();
    }

    private void updateConnections(ScrollingList connectionScrollList, final List<ColonyConnection> connectionData) {
        connectionScrollList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return connectionData.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyConnection colonyData = (ColonyConnection)connectionData.get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)colonyData.name));
                ((Text)rowPane.findPaneOfTypeByID("distance", Text.class)).setText(Component.translatable((String)"com.minecolonies.coremod.dist.blocks", (Object[])new Object[]{(int)BlockPosUtil.dist(colonyData.pos, ((ITownHallView)WindowAlliancePage.this.buildingView).getColony().getCenter())}));
                ((Text)rowPane.findPaneOfTypeByID("state", Text.class)).setText(Component.translatable((String)colonyData.diplomacyStatus.translationKey()));
                ((Button)rowPane.findPaneOfTypeByID(WindowAlliancePage.REQUEST_ALLY, Button.class)).setVisible(colonyData.diplomacyStatus == DiplomacyStatus.NEUTRAL);
                ((Button)rowPane.findPaneOfTypeByID(WindowAlliancePage.START_FEUD, Button.class)).setVisible(colonyData.diplomacyStatus == DiplomacyStatus.NEUTRAL);
                ((Button)rowPane.findPaneOfTypeByID(WindowAlliancePage.SET_NEUTRAL, Button.class)).setVisible(colonyData.diplomacyStatus != DiplomacyStatus.NEUTRAL);
            }
        });
    }

    private void updateEvents() {
        this.connectionEvents.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowAlliancePage.this.buildingView).getColony().getConnectionManager().getConnectionEvents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                List<ConnectionEvent> list = ((ITownHallView)WindowAlliancePage.this.buildingView).getColony().getConnectionManager().getConnectionEvents();
                int revIndex = list.size() - 1 - index;
                ConnectionEvent eventData = list.get(revIndex);
                DiplomacyStatus diplomacyStatus = ((ITownHallView)WindowAlliancePage.this.buildingView).getColony().getConnectionManager().getColonyDiplomacyStatus(eventData.id());
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)eventData.name()));
                ((Text)rowPane.findPaneOfTypeByID("desc", Text.class)).setText(Component.translatable((String)eventData.connectionEventType().translationKey()));
                ((Button)rowPane.findPaneOfTypeByID(WindowAlliancePage.ACCEPT_ALLY, Button.class)).setVisible(eventData.connectionEventType() == ConnectionEventType.ALLY_REQUEST && diplomacyStatus != DiplomacyStatus.ALLIES);
            }
        });
    }

    @Override
    protected String getWindowId() {
        return "alliances";
    }
}

