/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.PermissionEvent;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.network.messages.PermissionsMessage;
import com.minecolonies.core.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import com.minecolonies.core.network.messages.server.colony.building.GiveToolMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WindowPermissionsPage
extends AbstractWindowTownHall {
    @NotNull
    private final List<ColonyPlayer> users = new ArrayList<ColonyPlayer>();
    private ScrollingList userList;
    private ScrollingList actionsList;
    private ScrollingList freeBlocksList;
    private final ScrollingList rankButtonList;
    private final List<Rank> rankList = new LinkedList<Rank>();
    private final List<Rank> allRankList = new LinkedList<Rank>();
    private Rank actionsRank;
    private List<Action> actions = new ArrayList<Action>();
    private Map<Integer, String> rankTypes = new HashMap<Integer, String>();
    private ScrollingList eventList;
    private List<PlayerInfo> nonAddedPlayerList;

    public WindowPermissionsPage(BuildingTownHall.View building) {
        super(building, "layoutpermissions.xml");
        this.actions.addAll(Arrays.asList(Action.values()));
        this.rankTypes.put(0, "com.minecolonies.coremod.gui.townhall.ranktype.colonymanager");
        this.rankTypes.put(1, "com.minecolonies.coremod.gui.townhall.ranktype.hostile");
        this.rankTypes.put(2, "com.minecolonies.coremod.gui.townhall.ranktype.none");
        this.actionsRank = building.getColony().getPermissions().getRankOfficer();
        ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(false);
        this.rankButtonList = (ScrollingList)this.findPaneOfTypeByID("rankButtonList", ScrollingList.class);
        this.actionsList = (ScrollingList)this.findPaneOfTypeByID("rankList", ScrollingList.class);
        this.updateUsers();
        this.registerButton("addPlayer", this::addPlayerCLicked);
        this.registerButton("removePlayer", this::removePlayerClicked);
        this.registerButton("trigger", this::trigger);
        this.registerButton("addBlock", this::addBlock);
        this.registerButton("removeBlock", this::removeBlock);
        this.registerButton("blockTool", this::giveBlockTool);
        this.registerButton("buttonAddRank", this::addRank);
        this.registerButton("rankButton", this::onRankButtonClicked);
        this.registerButton("removeRank", this::onRemoveRankButtonClicked);
        this.registerButton("addfakeplayer", this::addPlayerToColonyClicked);
        this.registerButton("addOnlinePlayer", this::onPickPlayer);
        this.fillEventsList();
        this.fillnonAddedPlayerList();
    }

    private void fillnonAddedPlayerList() {
        this.nonAddedPlayerList = new ArrayList<PlayerInfo>();
        for (PlayerInfo info : Minecraft.getInstance().player.connection.getOnlinePlayers()) {
            if (((ITownHallView)this.buildingView).getColony().getPlayers().containsKey(info.getProfile().getId())) continue;
            this.nonAddedPlayerList.add(info);
        }
    }

    private void onPickPlayer(Button button) {
        if (this.nonAddedPlayerList.isEmpty()) {
            return;
        }
        final ScrollingList list = (ScrollingList)this.findPaneOfTypeByID("playerPicker", ScrollingList.class);
        list.setVisible(true);
        list.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.nonAddedPlayerList.size();
            }

            public void updateElement(int index, Pane pane) {
                String playerName = WindowPermissionsPage.this.nonAddedPlayerList.get(index).getProfile().getName();
                Button button = (Button)pane.findPaneOfTypeByID("playerSelectButton", Button.class);
                button.setText(Component.literal((String)playerName));
                button.setEnabled(true);
                button.setHandler(button1 -> {
                    TextField input = (TextField)WindowPermissionsPage.this.findPaneOfTypeByID("addPlayerName", TextField.class);
                    input.setText(button1.getTextAsString());
                    list.setVisible(false);
                });
            }
        });
    }

    private void addPlayerToColonyClicked(@NotNull Button button) {
        int row = this.eventList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < ((ITownHallView)this.buildingView).getPermissionEvents().size()) {
            PermissionEvent user = ((ITownHallView)this.buildingView).getPermissionEvents().get(row);
            new PermissionsMessage.AddPlayerOrFakePlayer(((ITownHallView)this.buildingView).getColony(), user.getName(), user.getId()).sendToServer();
        }
    }

    private void changeRankMode(DropDownList dropdown) {
        new PermissionsMessage.EditRankType(((ITownHallView)this.buildingView).getColony(), this.actionsRank, dropdown.getSelectedIndex()).sendToServer();
    }

    private void addRank() {
        TextField input = (TextField)this.findPaneOfTypeByID("addRankName", TextField.class);
        if (this.isValidRankname(input.getText())) {
            new PermissionsMessage.AddRank(((ITownHallView)this.buildingView).getColony(), input.getText()).sendToServer();
            input.setText("");
            SoundUtils.playSuccessSound((Player)Minecraft.getInstance().player, Minecraft.getInstance().player.blockPosition());
        } else {
            SoundUtils.playErrorSound((Player)Minecraft.getInstance().player, Minecraft.getInstance().player.blockPosition());
        }
    }

    private boolean isValidRankname(String name) {
        if (name.equals("")) {
            return false;
        }
        for (Rank rank : this.rankList) {
            if (!rank.getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private void onRemoveRankButtonClicked(Button button) {
        if (this.actionsRank != null) {
            new PermissionsMessage.RemoveRank(((ITownHallView)this.buildingView).getColony(), this.actionsRank).sendToServer();
            ((ITownHallView)this.buildingView).getColony().getPermissions().removeRank(this.actionsRank);
            this.actionsRank = ((ITownHallView)this.buildingView).getColony().getPermissions().getRankOfficer();
            button.setEnabled(false);
        }
    }

    private void updateUsers() {
        this.users.clear();
        this.users.addAll(((ITownHallView)this.buildingView).getColony().getPlayers().values());
        this.users.sort(Comparator.comparing(ColonyPlayer::getRank, Rank::compareTo));
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.fillUserList();
        this.fillFreeBlockList();
        this.fillRanks();
        this.fillPermissionList();
        LocalPlayer player = Minecraft.getInstance().player;
        Button addPlayerButton = (Button)this.findPaneOfTypeByID("addPlayer", Button.class);
        TextField playerNameField = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        TextField rankNameField = (TextField)this.findPaneOfTypeByID("addRankName", TextField.class);
        Button addRankButton = (Button)this.findPaneOfTypeByID("buttonAddRank", Button.class);
        Button addBlockButton = (Button)this.findPaneOfTypeByID("addBlock", Button.class);
        Button blockToolButton = (Button)this.findPaneOfTypeByID("blockTool", Button.class);
        if (((ITownHallView)this.buildingView).getColony().getPermissions().hasPermission((Player)player, Action.EDIT_PERMISSIONS)) {
            addPlayerButton.setEnabled(true);
            playerNameField.setEnabled(true);
            rankNameField.setEnabled(true);
            addRankButton.setEnabled(true);
            addBlockButton.setEnabled(true);
            blockToolButton.setEnabled(true);
        } else {
            AbstractTextBuilder.TooltipBuilder hoverText = PaneBuilders.tooltipBuilder().hoverPane((Pane)playerNameField);
            ((AbstractTextBuilder.TooltipBuilder)hoverText.append(Component.translatableEscape((String)"com.minecolonies.coremod.gui.townhall.player_permission_error", (Object[])new Object[0]))).paragraphBreak();
            hoverText.build();
            AbstractTextBuilder.TooltipBuilder hoverText2 = PaneBuilders.tooltipBuilder().hoverPane((Pane)rankNameField);
            ((AbstractTextBuilder.TooltipBuilder)hoverText2.append(Component.translatableEscape((String)"com.minecolonies.core.gui.townhall.rank_permission_error", (Object[])new Object[0]))).paragraphBreak();
            hoverText2.build();
            rankNameField.setEnabled(false);
            addPlayerButton.setEnabled(false);
            playerNameField.setEnabled(false);
            addRankButton.setEnabled(false);
            addBlockButton.setEnabled(false);
            blockToolButton.setEnabled(false);
        }
        ((DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class)).setSelectedIndex(this.actionsRank.isColonyManager() ? 0 : (this.actionsRank.isHostile() ? 1 : 2));
    }

    private void updateRanks() {
        this.rankList.clear();
        for (Rank rank : ((ITownHallView)this.buildingView).getColony().getPermissions().getRanks().values()) {
            if (rank.equals(((ITownHallView)this.buildingView).getColony().getPermissions().getRankOwner())) continue;
            this.rankList.add(rank);
        }
        this.allRankList.clear();
        this.allRankList.addAll(((ITownHallView)this.buildingView).getColony().getPermissions().getRanks().values());
    }

    private void fillRanks() {
        this.rankButtonList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.allRankList.size();
            }

            public void updateElement(int i, Pane pane) {
                Rank rank = WindowPermissionsPage.this.allRankList.get(i);
                Button button = (Button)pane.findPaneOfTypeByID("rankButton", Button.class);
                button.setText(Component.literal((String)rank.getName()));
                button.setEnabled(!rank.equals(WindowPermissionsPage.this.actionsRank));
                ((Text)pane.findPaneOfTypeByID("rankId", Text.class)).setText(Component.literal((String)Integer.toString(rank.getId())));
            }
        });
        DropDownList dropdown = (DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class);
        dropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.rankTypes.size();
            }

            public MutableComponent getLabel(int i) {
                return Component.translatableEscape((String)WindowPermissionsPage.this.rankTypes.get(i), (Object[])new Object[0]);
            }
        });
        dropdown.setHandler(this::changeRankMode);
    }

    private void onRankButtonClicked(@NotNull Button button) {
        int rankId = this.rankButtonList.getListElementIndexByPane((Pane)button);
        Rank rank = this.allRankList.get(rankId);
        if (rank != null) {
            this.actionsRank = rank;
            button.setEnabled(false);
            ((Button)this.findPaneOfTypeByID("removeRank", Button.class)).setEnabled(!this.actionsRank.isInitial());
            ((DropDownList)this.findPaneOfTypeByID("rankTypePicker", DropDownList.class)).setSelectedIndex(this.actionsRank.isColonyManager() ? 0 : (this.actionsRank.isHostile() ? 1 : 2));
        }
    }

    private void fillEventsList() {
        this.eventList = (ScrollingList)this.findPaneOfTypeByID("eventsList", ScrollingList.class);
        this.eventList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowPermissionsPage.this.buildingView).getPermissionEvents().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text nameLabel = (Text)rowPane.findPaneOfTypeByID("name", Text.class);
                Text actionLabel = (Text)rowPane.findPaneOfTypeByID("action", Text.class);
                List<PermissionEvent> permissionEvents = ((ITownHallView)WindowPermissionsPage.this.buildingView).getPermissionEvents();
                Collections.reverse(permissionEvents);
                PermissionEvent event = permissionEvents.get(index);
                nameLabel.setText(Component.literal((String)(event.getName() + (event.getId() == null ? " <fake>" : ""))));
                ((Text)rowPane.findPaneOfTypeByID("pos", Text.class)).setText(Component.literal((String)(event.getPosition().getX() + " " + event.getPosition().getY() + " " + event.getPosition().getZ())));
                ((Button)rowPane.findPaneOfTypeByID("addfakeplayer", Button.class)).setVisible(event.getId() != null);
                actionLabel.setText(Component.translatableEscape((String)("com.minecolonies.coremod.permission." + event.getAction().toString().toLowerCase(Locale.US)), (Object[])new Object[0]));
            }
        });
    }

    private void removeBlock(Button button) {
        int row = this.freeBlocksList.getListElementIndexByPane((Pane)button);
        if (row >= 0) {
            @NotNull List<Block> freeBlocks = ((ITownHallView)this.buildingView).getColony().getFreeBlocks();
            @NotNull List<BlockPos> freePositions = ((ITownHallView)this.buildingView).getColony().getFreePositions();
            if (row < freeBlocks.size()) {
                new ChangeFreeToInteractBlockMessage(((ITownHallView)this.buildingView).getColony(), freeBlocks.get(row), ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK).sendToServer();
                ((ITownHallView)this.buildingView).getColony().removeFreeBlock(freeBlocks.get(row));
            } else if (row < freeBlocks.size() + freePositions.size()) {
                BlockPos freePos = freePositions.get(row - freeBlocks.size());
                new ChangeFreeToInteractBlockMessage(((ITownHallView)this.buildingView).getColony(), freePos, ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK).sendToServer();
                ((ITownHallView)this.buildingView).getColony().removeFreePosition(freePos);
            }
            this.fillFreeBlockList();
        }
    }

    private void giveBlockTool(Button button) {
        new GiveToolMessage(this.buildingView, ModItems.permTool).sendToServer();
    }

    private void fillFreeBlockList() {
        final @NotNull List<Block> freeBlocks = ((ITownHallView)this.buildingView).getColony().getFreeBlocks();
        final @NotNull List<BlockPos> freePositions = ((ITownHallView)this.buildingView).getColony().getFreePositions();
        this.freeBlocksList = (ScrollingList)this.findPaneOfTypeByID("blocks", ScrollingList.class);
        this.freeBlocksList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return freeBlocks.size() + freePositions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                if (index < freeBlocks.size()) {
                    Block block = (Block)freeBlocks.get(index);
                    MutableComponent text = Component.literal((String)BuiltInRegistries.BLOCK.getKey((Object)block).toString());
                    text.append((Component)Component.literal((String)"\n")).append((Component)block.getName().withStyle(ChatFormatting.DARK_GRAY));
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(text);
                } else {
                    BlockPos pos = (BlockPos)freePositions.get(index - freeBlocks.size());
                    MutableComponent text = Component.literal((String)(pos.getX() + " " + pos.getY() + " " + pos.getZ()));
                    if (((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getWorld().isLoaded(pos)) {
                        BlockState state = ((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getWorld().getBlockState(pos);
                        text.append((Component)Component.literal((String)"\n")).append((Component)state.getBlock().getName().withStyle(ChatFormatting.DARK_GRAY));
                    }
                    ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(text);
                }
                boolean canEdit = ((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getPermissions().hasPermission((Player)Minecraft.getInstance().player, Action.EDIT_PERMISSIONS);
                ((Button)rowPane.findPaneOfTypeByID("removeBlock", Button.class)).setEnabled(canEdit);
            }
        });
    }

    private void addBlock() {
        TextField input = (TextField)this.findPaneOfTypeByID("addBlockName", TextField.class);
        String inputText = input.getText();
        try {
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)inputText));
            if (block != null && !block.defaultBlockState().isAir()) {
                ((ITownHallView)this.buildingView).getColony().addFreeBlock(block);
                new ChangeFreeToInteractBlockMessage(((ITownHallView)this.buildingView).getColony(), block, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK).sendToServer();
            }
        }
        catch (ResourceLocationException block) {
            // empty catch block
        }
        BlockPos pos = BlockPosUtil.getBlockPosOfString(inputText);
        if (pos != null) {
            new ChangeFreeToInteractBlockMessage(((ITownHallView)this.buildingView).getColony(), pos, ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK).sendToServer();
            ((ITownHallView)this.buildingView).getColony().addFreePosition(pos);
        }
        this.fillFreeBlockList();
        input.setText("");
    }

    private void trigger(@NotNull Button button) {
        String string;
        int index = this.actionsList.getListElementIndexByPane((Pane)button);
        Action action = this.actions.get(index);
        IPermissions permissions = ((ITownHallView)this.buildingView).getColony().getPermissions();
        LocalPlayer playerEntity = Minecraft.getInstance().player;
        ComponentContents componentContents = button.getText().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents contents = (TranslatableContents)componentContents;
            string = contents.getKey();
        } else {
            string = button.getTextAsString();
        }
        String key = string;
        boolean enable = !"com.minecolonies.coremod.gui.workerhuts.retrieveon".equals(key);
        button.disable();
        if (!permissions.alterPermission(permissions.getRank((Player)playerEntity), this.actionsRank, action, enable)) {
            return;
        }
        new PermissionsMessage.Permission(((ITownHallView)this.buildingView).getColony(), enable, this.actionsRank, action).sendToServer();
        if (!enable) {
            button.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
        } else {
            button.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]));
        }
    }

    private void fillPermissionList() {
        this.actionsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.actions.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Action action = WindowPermissionsPage.this.actions.get(index);
                MutableComponent name = Component.translatableEscape((String)("com.minecolonies.coremod.permission." + action.toString().toLowerCase(Locale.US)), (Object[])new Object[0]);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText((Component)name);
                boolean isTriggered = ((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getPermissions().hasPermission(WindowPermissionsPage.this.actionsRank, action);
                Button onOffButton = (Button)rowPane.findPaneOfTypeByID("trigger", Button.class);
                onOffButton.setText(isTriggered ? Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon", (Object[])new Object[0]) : Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff", (Object[])new Object[0]));
                ((Text)rowPane.findPaneOfTypeByID("index", Text.class)).setText(Component.literal((String)Integer.toString(index)));
                if (!((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getPermissions().canAlterPermission(((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getPermissions().getRank((Player)Minecraft.getInstance().player), WindowPermissionsPage.this.actionsRank, action)) {
                    onOffButton.disable();
                } else {
                    onOffButton.enable();
                }
            }
        });
    }

    private void fillUserList() {
        this.userList = (ScrollingList)this.findPaneOfTypeByID("users", ScrollingList.class);
        this.userList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPermissionsPage.this.users.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ColonyPlayer player = WindowPermissionsPage.this.users.get(index);
                Rank rank = player.getRank();
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)player.getName()));
                DropDownList dropdown = (DropDownList)rowPane.findPaneOfTypeByID("rankPicker", DropDownList.class);
                int n = rank.getId();
                ((ITownHallView)WindowPermissionsPage.this.buildingView).getColony().getPermissions();
                if (n == 0) {
                    ((Button)rowPane.findPaneOfTypeByID("removePlayer", Button.class)).setEnabled(false);
                    ((Text)rowPane.findPaneOfTypeByID("rank", Text.class)).setText(Component.literal((String)rank.getName()));
                    dropdown.setEnabled(false);
                } else {
                    dropdown.setDataProvider(new DropDownList.DataProvider(){

                        public int getElementCount() {
                            return WindowPermissionsPage.this.rankList.size();
                        }

                        public MutableComponent getLabel(int i) {
                            Rank rank = WindowPermissionsPage.this.rankList.get(i);
                            return Component.literal((String)rank.getName());
                        }
                    });
                    dropdown.setSelectedIndex(WindowPermissionsPage.this.rankList.indexOf(rank));
                    dropdown.setHandler(WindowPermissionsPage.this::onRankSelected);
                }
            }
        });
    }

    private void onRankSelected(DropDownList dropdown) {
        int index = dropdown.getSelectedIndex();
        ColonyPlayer player = this.users.get(this.userList.getListElementIndexByPane((Pane)dropdown));
        Rank rank = this.rankList.get(index);
        if (rank != player.getRank()) {
            player.setRank(rank);
            new PermissionsMessage.ChangePlayerRank(((ITownHallView)this.buildingView).getColony(), player.getID(), rank).sendToServer();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.updateUsers();
        this.updateRanks();
    }

    private void addPlayerCLicked() {
        TextField input = (TextField)this.findPaneOfTypeByID("addPlayerName", TextField.class);
        new PermissionsMessage.AddPlayer(((ITownHallView)this.buildingView).getColony(), input.getText()).sendToServer();
        input.setText("");
    }

    private void removePlayerClicked(Button button) {
        ColonyPlayer user;
        int row = this.userList.getListElementIndexByPane((Pane)button);
        if (row >= 0 && row < this.users.size() && (user = this.users.get(row)).getRank().getId() != 0) {
            new PermissionsMessage.RemovePlayer(((ITownHallView)this.buildingView).getColony(), user.getID()).sendToServer();
        }
    }

    @Override
    protected String getWindowId() {
        return "permissions";
    }
}

