/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.core.blocks.BlockDecorationController;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityDecoControllerRenderer
implements BlockEntityRenderer<BlockEntity> {
    private BlockRenderDispatcher blockRenderer;

    public TileEntityDecoControllerRenderer(BlockEntityRendererProvider.Context p_173623_) {
        this.blockRenderer = p_173623_.getBlockRenderDispatcher();
    }

    public void render(@NotNull BlockEntity blockEntity, float partialTick, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource bufferSource, int lightA, int lightB) {
        if (blockEntity instanceof TileEntityDecorationController) {
            TileEntityDecorationController decorationController = (TileEntityDecorationController)blockEntity;
            Level level = blockEntity.getLevel();
            if (level != null) {
                Vec3 translateVec;
                BlockState decoController = decorationController.getBlockState();
                Direction direction = (Direction)decoController.getValue((Property)BlockDecorationController.FACING);
                BlockPos offsetPos = blockEntity.getBlockPos().relative(direction);
                BlockState state = level.getBlockState(offsetPos);
                VoxelShape shape = state.getShape((BlockGetter)level, offsetPos);
                if (shape.isEmpty() || Block.isShapeFullBlock((VoxelShape)shape)) {
                    ModelBlockRenderer.enableCaching();
                    matrixStack.pushPose();
                    this.renderBlock(offsetPos, decoController, matrixStack, bufferSource, level, lightA);
                    matrixStack.popPose();
                    ModelBlockRenderer.clearCache();
                    return;
                }
                switch (direction) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case UP: {
                        Vec3 vec3 = new Vec3(0.0, shape.min(Direction.Axis.Y), 0.0);
                        break;
                    }
                    case DOWN: {
                        Vec3 vec3 = new Vec3(0.0, shape.max(Direction.Axis.Y) - 1.0, 0.0);
                        break;
                    }
                    case NORTH: {
                        Vec3 vec3 = new Vec3(0.0, 0.0, shape.max(Direction.Axis.Z) - 1.0);
                        break;
                    }
                    case SOUTH: {
                        Vec3 vec3 = new Vec3(0.0, 0.0, shape.min(Direction.Axis.Z));
                        break;
                    }
                    case EAST: {
                        Vec3 vec3 = new Vec3(shape.min(Direction.Axis.X), 0.0, 0.0);
                        break;
                    }
                    case WEST: {
                        Vec3 vec3 = translateVec = new Vec3(shape.max(Direction.Axis.X) - 1.0, 0.0, 0.0);
                    }
                }
                if (!decoController.isAir()) {
                    ModelBlockRenderer.enableCaching();
                    matrixStack.pushPose();
                    matrixStack.translate(translateVec.x, translateVec.y, translateVec.z);
                    this.renderBlock(offsetPos, decoController, matrixStack, bufferSource, level, lightB);
                    matrixStack.popPose();
                    ModelBlockRenderer.clearCache();
                }
            }
        }
    }

    private void renderBlock(BlockPos pos, BlockState state, PoseStack poseStack, MultiBufferSource buffer, Level level, int light) {
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.cutout());
        this.blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)level, this.blockRenderer.getBlockModel(state), state, pos, poseStack, vertexconsumer, false, RandomSource.create(), state.getSeed(pos), light);
    }
}

