/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.plantation.IPlantationModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildingextensions.AbstractBuildingExtension;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PlantationField
extends AbstractBuildingExtension {
    private static final String TAG_WORKING_POS = "workingPositions";
    private List<BlockPos> workingPositions = new ArrayList<BlockPos>();

    public PlantationField(@NotNull BuildingExtensionRegistries.BuildingExtensionEntry fieldType, @NotNull BlockPos position) {
        super(fieldType, position);
    }

    public static PlantationField create(BuildingExtensionRegistries.BuildingExtensionEntry extensionEntry, BlockPos position) {
        return (PlantationField)extensionEntry.produceExtension(position);
    }

    @Override
    public boolean isValidPlacement(IColony colony) {
        BlockState blockState = colony.getWorld().getBlockState(this.getPosition());
        return blockState.is(ModBlocks.blockHutPlantation) || blockState.is(ModBlocks.blockPlantationField);
    }

    public List<BlockPos> getWorkingPositions() {
        return this.workingPositions.stream().toList();
    }

    public void setWorkingPositions(List<BlockPos> workingPositions) {
        this.workingPositions = workingPositions;
    }

    public IPlantationModule getModule() {
        return (IPlantationModule)this.getFirstModuleOccurance(IPlantationModule.class);
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        BlockPosUtil.writePosListToNBT(compound, TAG_WORKING_POS, this.workingPositions);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.workingPositions = BlockPosUtil.readPosListFromNBT(compound, TAG_WORKING_POS);
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.workingPositions.size());
        for (BlockPos workingPosition : this.workingPositions) {
            buf.writeBlockPos(workingPosition);
        }
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        super.deserialize(buf);
        this.workingPositions = new ArrayList<BlockPos>();
        int workingPositionCount = buf.readInt();
        for (int index = 0; index < workingPositionCount; ++index) {
            this.workingPositions.add(buf.readBlockPos());
        }
    }
}

