/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.entity.ai.workers.util.MineNode;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLevelManagementModule
extends AbstractBuildingModule
implements IPersistentModule {
    @NotNull
    private final List<MinerLevel> levels = new ArrayList<MinerLevel>();
    private int currentLevel = 0;
    @Nullable
    private MineNode activeNode = null;
    @Nullable
    private MineNode oldNode = null;
    private int startingLevelShaft = 0;

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.startingLevelShaft = compound.getInt("newStartingLevelShaft");
        this.currentLevel = compound.getInt("currentLevel");
        ListTag levelTagList = compound.getList("levels", 10);
        for (int i = 0; i < levelTagList.size(); ++i) {
            this.levels.add(new MinerLevel(levelTagList.getCompound(i)));
        }
        if (compound.contains("activeNodeNode")) {
            this.activeNode = MineNode.createFromNBT(compound.getCompound("activeNodeNode"));
        } else if (compound.contains("oldNodeNode")) {
            this.oldNode = MineNode.createFromNBT(compound.getCompound("oldNodeNode"));
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        CompoundTag nodeCompound;
        compound.putInt("newStartingLevelShaft", this.startingLevelShaft);
        compound.putInt("currentLevel", this.currentLevel);
        @NotNull ListTag levelTagList = new ListTag();
        for (MinerLevel level : this.levels) {
            @NotNull CompoundTag levelCompound = new CompoundTag();
            level.write(levelCompound);
            levelTagList.add((Object)levelCompound);
        }
        compound.put("levels", (Tag)levelTagList);
        if (this.activeNode != null) {
            nodeCompound = new CompoundTag();
            this.activeNode.write(nodeCompound);
            compound.put("activeNodeNode", (Tag)nodeCompound);
        }
        if (this.oldNode != null) {
            nodeCompound = new CompoundTag();
            this.oldNode.write(nodeCompound);
            compound.put("oldNodeNode", (Tag)nodeCompound);
        }
    }

    @Override
    public void serializeToView(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (MinerLevel level : this.levels) {
            buf.writeInt(level.getNumberOfBuiltNodes());
            buf.writeInt(level.getDepth());
        }
        List<WorkOrderMiner> list = this.building.getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, this.building.getPosition());
        buf.writeInt(list.size());
        for (WorkOrderMiner wo : list) {
            wo.serializeViewNetworkData(buf);
        }
    }

    public void addLevel(MinerLevel currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public MinerLevel getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public int getLevelId(MinerLevel level) {
        return this.levels.indexOf(level);
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
        this.activeNode = null;
        this.oldNode = null;
    }

    public int getStartingLevelShaft() {
        if (this.levels.isEmpty()) {
            return this.startingLevelShaft;
        }
        return this.levels.get(this.levels.size() - 1).getDepth() - 6;
    }

    @Nullable
    public MineNode getActiveNode() {
        if (this.levels.isEmpty()) {
            return null;
        }
        MineNode calcNode = this.activeNode;
        if (this.activeNode == null || this.activeNode.getStatus() == MineNode.NodeStatus.COMPLETED) {
            if (this.currentLevel >= this.levels.size()) {
                this.currentLevel = this.levels.size() - 1;
            }
            calcNode = this.levels.get(this.currentLevel).getRandomNode(this.oldNode);
        }
        if (this.activeNode != calcNode) {
            this.activeNode = calcNode;
        }
        return this.activeNode;
    }

    public void setActiveNode(@Nullable MineNode activeNode) {
        this.activeNode = activeNode;
    }

    public void setOldNode(@Nullable MineNode oldNode) {
        this.oldNode = oldNode;
    }

    public void setStartingLevelShaft(int level) {
        this.startingLevelShaft = level;
    }

    public void repairLevel(int level) {
        if (this.building instanceof BuildingMiner) {
            BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
            BlockPos vector = ladderPos.subtract((Vec3i)((BuildingMiner)this.building).getCobbleLocation());
            int xOffset = 3 * vector.getX();
            int zOffset = 3 * vector.getZ();
            BuildingMiner.initStructure(null, new BlockPos(ladderPos.getX() + xOffset, this.levels.get(level).getDepth(), ladderPos.getZ() + zOffset), (BuildingMiner)this.building, this.building.getColony().getWorld(), null);
        }
    }

    public List<MinerLevel> getLevels() {
        return this.levels;
    }
}

