/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.core.client.gui.modules.EnchanterStationModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.enchanter.EnchanterWorkerSetMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EnchanterStationsModuleView
extends AbstractBuildingModuleView {
    private List<BlockPos> buildingToGatherFrom = new ArrayList<BlockPos>();

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        int size = buf.readInt();
        this.buildingToGatherFrom.clear();
        for (int i = 0; i < size; ++i) {
            this.buildingToGatherFrom.add(buf.readBlockPos());
        }
    }

    public List<BlockPos> getBuildingsToGatherFrom() {
        return this.buildingToGatherFrom;
    }

    public void addWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.add(blockPos);
        new EnchanterWorkerSetMessage(this.buildingView, blockPos, true).sendToServer();
    }

    public void removeWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.remove(blockPos);
        new EnchanterWorkerSetMessage(this.buildingView, blockPos, false).sendToServer();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new EnchanterStationModuleWindow(this);
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/entity.png");
    }

    @Override
    public Component getDesc() {
        return Component.translatable((String)"com.minecolonies.gui.workerhuts.enchanter.workers");
    }
}

