/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BuildingAlchemist
extends AbstractBuilding {
    private static final String ALCHEMIST = "alchemist";
    private final List<BlockPos> soulsand = new ArrayList<BlockPos>();
    private final List<BlockPos> leaves = new ArrayList<BlockPos>();
    private final List<BlockPos> brewingStands = new ArrayList<BlockPos>();

    public BuildingAlchemist(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.getItem() == Items.NETHER_WART, new Tuple((Object)16, (Object)false));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return ALCHEMIST;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.getBlock() == Blocks.SOUL_SAND) {
            this.soulsand.add(pos);
        } else if (block.is(BlockTags.LEAVES)) {
            this.leaves.add(pos);
        } else if (block.getBlock() == Blocks.BREWING_STAND) {
            this.brewingStands.add(pos);
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag sandPos = compound.getList("plantGround", 11);
        for (int i = 0; i < sandPos.size(); ++i) {
            this.soulsand.add(NBTUtils.readBlockPos(sandPos.get(i)));
        }
        ListTag leavesPos = compound.getList("leaves", 11);
        for (int i = 0; i < leavesPos.size(); ++i) {
            this.leaves.add(NBTUtils.readBlockPos(leavesPos.get(i)));
        }
        ListTag brewingStandPos = compound.getList("brewingStand", 11);
        for (int i = 0; i < brewingStandPos.size(); ++i) {
            this.brewingStands.add(NBTUtils.readBlockPos(brewingStandPos.get(i)));
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull ListTag sandCompoundList = new ListTag();
        for (BlockPos blockPos : this.soulsand) {
            sandCompoundList.add((Object)NBTUtils.writeBlockPos(blockPos));
        }
        compound.put("plantGround", (Tag)sandCompoundList);
        @NotNull ListTag leavesCompoundList = new ListTag();
        for (BlockPos entry : this.leaves) {
            leavesCompoundList.add((Object)NBTUtils.writeBlockPos(entry));
        }
        compound.put("leaves", (Tag)leavesCompoundList);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos entry : this.brewingStands) {
            listTag.add((Object)NBTUtils.writeBlockPos(entry));
        }
        compound.put("brewingStand", (Tag)listTag);
        return compound;
    }

    public List<BlockPos> getAllSoilPositions() {
        return new ArrayList<BlockPos>(this.soulsand);
    }

    public List<BlockPos> getAllLeavePositions() {
        return new ArrayList<BlockPos>(this.leaves);
    }

    public List<BlockPos> getAllBrewingStandPositions() {
        return new ArrayList<BlockPos>(this.brewingStands);
    }

    public void removeBrewingStand(BlockPos pos) {
        this.brewingStands.remove(pos);
    }

    public void removeSoilPosition(BlockPos pos) {
        this.soulsand.remove(pos);
    }

    public void removeLeafPosition(BlockPos pos) {
        this.leaves.remove(pos);
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return recipe.getPrimaryOutput().getItem() == ModItems.magicpotion;
        }

        @Override
        public Set<CraftingType> getSupportedCraftingTypes() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            recipes.add(GenericRecipe.builder().withOutput((ItemLike)ModItems.mistletoe).withIntermediate(Blocks.OAK_LEAVES).withRequiredTool((EquipmentTypeEntry)ModEquipmentTypes.shears.get()).build());
            recipes.add(GenericRecipe.builder().withOutput((ItemLike)Items.NETHER_WART, 4).withInputs(List.of(List.of(Items.NETHER_WART.getDefaultInstance()))).withIntermediate(Blocks.SOUL_SAND).build());
            return recipes;
        }
    }

    public static class BrewingModule
    extends AbstractCraftingBuildingModule.Brewing {
        public BrewingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

