/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.interactionhandling;

import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.interactionhandling.ModInteractionResponseHandlers;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.WindowRequestDetail;
import com.minecolonies.core.client.gui.citizen.RequestWindowCitizen;
import com.minecolonies.core.colony.interactionhandling.ServerCitizenInteraction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class RequestBasedInteraction
extends ServerCitizenInteraction {
    private static final String TOKEN_TAG = "token";
    private static final Tuple<Component, Component>[] tuples = new Tuple[]{new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.okay", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.remindmelater", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.cancel", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.fulfill", (Object[])new Object[0]), Component.empty())};
    private static final Tuple<Component, Component>[] tuplesAsync = new Tuple[]{new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.okay", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.ignore", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.remindmelater", (Object[])new Object[0]), Component.empty()), new Tuple<MutableComponent, MutableComponent>(Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.skipchitchat", (Object[])new Object[0]), Component.empty())};
    private IToken<?> token = null;
    private BiPredicate<ICitizenData, IToken<?>> validator;

    public RequestBasedInteraction(Component inquiry, IChatPriority priority, Component validator, IToken<?> token) {
        super(inquiry, true, priority, null, validator, priority == ChatPriority.BLOCKING ? tuples : tuplesAsync);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(validator);
        this.token = token;
    }

    public RequestBasedInteraction(Component inquiry, IChatPriority priority, IToken<?> token) {
        super(inquiry, true, priority, null, inquiry, tuples);
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(inquiry);
        this.token = token;
    }

    public RequestBasedInteraction(ICitizen data) {
        super(data);
    }

    @Override
    public List<IInteractionResponseHandler> genChildInteractions() {
        return Collections.emptyList();
    }

    @Override
    public boolean isValid(ICitizenData citizen) {
        return this.validator == null && !this.parents.isEmpty() || this.validator != null && this.validator.test(citizen, this.token);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        tag.put(TOKEN_TAG, (Tag)StandardFactoryController.getInstance().serializeTag(provider, this.token));
        return tag;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compoundNBT) {
        super.deserializeNBT(provider, compoundNBT);
        this.token = (IToken)StandardFactoryController.getInstance().deserializeTag(provider, compoundNBT.getCompound(TOKEN_TAG));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onWindowOpened(BOWindow window, ICitizenDataView dataView) {
        IRequest<?> request;
        IColonyView colony = IColonyManager.getInstance().getColonyView(dataView.getColonyId(), (ResourceKey<Level>)Minecraft.getInstance().player.level().dimension());
        if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
            ItemIcon icon = (ItemIcon)window.findPaneOfTypeByID("requestItem", ItemIcon.class);
            if (!request.getDisplayStacks().isEmpty()) {
                icon.setItem(request.getDisplayStacks().get(0));
            }
            icon.show();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean onClientResponseTriggered(int responseId, Player player, ICitizenDataView data, BOWindow window) {
        if (((TranslatableContents)this.getPossibleResponses().get(responseId).getContents()).getKey().equals("com.minecolonies.coremod.gui.chat.fulfill")) {
            IRequest<?> request;
            IColonyView colony = IColonyManager.getInstance().getColonyView(data.getColonyId(), (ResourceKey<Level>)player.level().dimension());
            if (colony != null && (request = colony.getRequestManager().getRequestForToken(this.token)) != null) {
                RequestWindowCitizen windowCitizen = new RequestWindowCitizen(data);
                windowCitizen.open();
                WindowRequestDetail windowRequestDetail = new WindowRequestDetail(windowCitizen, request, data.getColonyId());
                windowRequestDetail.open();
                return false;
            }
        } else {
            return super.onClientResponseTriggered(responseId, player, data, window);
        }
        return true;
    }

    @Override
    public void onServerResponseTriggered(int responseId, Player player, ICitizenData data) {
        super.onServerResponseTriggered(responseId, player, data);
        Component response = this.getPossibleResponses().get(responseId);
        if (response.equals((Object)Component.translatableEscape((String)"com.minecolonies.coremod.gui.chat.cancel", (Object[])new Object[0])) && data.getColony() != null) {
            data.getColony().getRequestManager().updateRequestState(this.token, RequestState.CANCELLED);
        }
    }

    @Override
    protected void loadValidator() {
        this.validator = InteractionValidatorRegistry.getTokenBasedInteractionValidatorPredicate(this.validatorId);
    }

    @Override
    public String getType() {
        return ModInteractionResponseHandlers.REQUEST.getPath();
    }
}

