/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.core.colony.buildings.modules.WarehouseRequestQueueModule;
import com.minecolonies.core.colony.jobs.JobDeliveryman;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractRequestResolver;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeliverymenRequestResolver<R extends IRequestable>
extends AbstractRequestResolver<R> {
    public DeliverymenRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    public boolean canResolveRequest(@NotNull IRequestManager manager, IRequest<? extends R> requestToCheck) {
        if (manager.getColony().getWorld().isClientSide) {
            return false;
        }
        if (manager.getColony().getBuildingManager().getBuilding(requestToCheck.getRequester().getLocation().getInDimensionLocation()) instanceof IWareHouse && !requestToCheck.getRequester().getLocation().equals(this.getLocation())) {
            return false;
        }
        return this.hasCouriers(manager);
    }

    public boolean hasCouriers(@NotNull IRequestManager manager) {
        Colony colony = (Colony)manager.getColony();
        IWareHouse wareHouse = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        if (wareHouse == null) {
            return false;
        }
        return !((CourierAssignmentModule)wareHouse.getModule(BuildingModules.WAREHOUSE_COURIERS)).getAssignedCitizen().isEmpty();
    }

    @Override
    public int getSuitabilityMetric(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        IWareHouse wareHouse = manager.getColony().getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        int distance = (int)BlockPosUtil.getDistance(request.getRequester().getLocation().getInDimensionLocation(), this.getLocation().getInDimensionLocation());
        if (wareHouse == null) {
            return distance;
        }
        return Math.max(distance / 10, 1) + ((WarehouseRequestQueueModule)wareHouse.getModule(BuildingModules.WAREHOUSE_REQUEST_QUEUE)).getMutableRequestList().size();
    }

    @Override
    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        if (manager.getColony().getWorld().isClientSide || !this.hasCouriers(manager)) {
            return null;
        }
        return Lists.newArrayList();
    }

    @Override
    public void resolveRequest(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) throws RuntimeException {
        Colony colony = (Colony)manager.getColony();
        IWareHouse wareHouse = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class);
        if (wareHouse == null) {
            return;
        }
        if (((CourierAssignmentModule)wareHouse.getModule(BuildingModules.WAREHOUSE_COURIERS)).getAssignedCitizen().isEmpty()) {
            return;
        }
        WarehouseRequestQueueModule module = (WarehouseRequestQueueModule)wareHouse.getModule(BuildingModules.WAREHOUSE_REQUEST_QUEUE);
        module.addRequest((IToken<?>)request.getId());
    }

    @Override
    @Nullable
    public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> completedRequest) {
        return null;
    }

    @Override
    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
    }

    @Override
    public void onAssignedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request) {
        if (!manager.getColony().getWorld().isClientSide) {
            IWareHouse wareHouse;
            Colony colony = (Colony)manager.getColony();
            ICitizenData freeDeliveryMan = colony.getCitizenManager().getCitizens().stream().filter(c -> c.getJob() instanceof JobDeliveryman && ((JobDeliveryman)c.getJob()).getTaskQueue().contains(request.getId())).findFirst().orElse(null);
            if (freeDeliveryMan != null) {
                JobDeliveryman job = (JobDeliveryman)freeDeliveryMan.getJob();
                job.onTaskDeletion((IToken<?>)request.getId());
            }
            if ((wareHouse = colony.getBuildingManager().getBuilding(this.getLocation().getInDimensionLocation(), IWareHouse.class)) == null) {
                return;
            }
            WarehouseRequestQueueModule module = (WarehouseRequestQueueModule)wareHouse.getModule(BuildingModules.WAREHOUSE_REQUEST_QUEUE);
            module.getMutableRequestList().remove(request.getId());
        }
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
    }

    @Override
    @NotNull
    public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        return Component.translatableEscape((String)"com.minecolonies.job.deliveryman", (Object[])new Object[0]);
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

