/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.arguments;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.arguments.MultipleOptionsArgument;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MultiColonyIdArgument
extends MultipleOptionsArgument<List<Integer>> {
    private MultiColonyIdArgument() {
        super(List.of(new AllOption(), WrappedSingleClass.of(ColonyIdArgument.HereOption::new), WrappedSingleClass.of(ColonyIdArgument.MineOption::new), WrappedSingleClass.of(ColonyIdArgument.ColonyIdOption::new), WrappedSingleClass.of(ColonyIdArgument.PlayerUuidOption::new), WrappedSingleClass.of(ColonyIdArgument.PlayerNameOption::new)));
    }

    public static MultiColonyIdArgument id() {
        return new MultiColonyIdArgument();
    }

    @NotNull
    public static List<IColony> getColonies(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        List<Integer> colonyIds = MultiColonyIdArgument.getColonyIds(context, name);
        ArrayList<IColony> colonies = new ArrayList<IColony>();
        for (int colonyId : colonyIds) {
            IColony colony = IColonyManager.getInstance().getColonyByWorld(colonyId, (Level)((CommandSourceStack)context.getSource()).getLevel());
            if (colony == null) continue;
            colonies.add(colony);
        }
        return colonies;
    }

    @NotNull
    public static List<Integer> getColonyIds(@NotNull CommandContext<CommandSourceStack> context, @NotNull String name) {
        try {
            return (List)MultiColonyIdArgument.getValue(context, name);
        }
        catch (CommandSyntaxException e) {
            Component message = ComponentUtils.fromMessage((Message)e.getRawMessage());
            ((CommandSourceStack)context.getSource()).sendFailure(message);
            throw new RuntimeException(message.getString());
        }
    }

    public static class AllOption
    implements MultipleOptionsArgument.ArgumentOption<List<Integer>> {
        @Override
        public boolean matches(String value) {
            return Objects.equals(value, "all");
        }

        @Override
        public List<Integer> resolveValue(CommandSourceStack source, String value) {
            return IColonyManager.getInstance().getAllColonies().stream().map(IColony::getID).toList();
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            builder.suggest("all", (Message)Component.translatable((String)"com.minecolonies.command.argument.colony.all"));
        }
    }

    private record WrappedSingleClass(MultipleOptionsArgument.ArgumentOption<Integer> wrapped) implements MultipleOptionsArgument.ArgumentOption<List<Integer>>
    {
        private static WrappedSingleClass of(Supplier<MultipleOptionsArgument.ArgumentOption<Integer>> wrapped) {
            return new WrappedSingleClass(wrapped.get());
        }

        @Override
        public boolean matches(String value) {
            return this.wrapped.matches(value);
        }

        @Override
        public List<Integer> resolveValue(CommandSourceStack source, String value) throws CommandSyntaxException {
            return List.of(this.wrapped.resolveValue(source, value));
        }

        @Override
        public void createSuggestions(Level world, SharedSuggestionProvider suggestionProvider, SuggestionsBuilder builder) {
            this.wrapped.createSuggestions(world, suggestionProvider, builder);
        }
    }
}

