/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.commands.arguments.ColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.network.messages.client.SyncPathMessage;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CommandCitizenTrack
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return 1;
        }
        IColony colony = ColonyIdArgument.getColony(context, "colonyID");
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.notfound", (Object[])new Object[0]), true);
            return 0;
        }
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.citizeninfo.notloaded", (Object[])new Object[0]), true);
            return 0;
        }
        AbstractEntityCitizen entityCitizen = optionalEntityCitizen.get();
        if (PathfindingUtils.trackingMap.getOrDefault(sender.getUUID(), UUID.randomUUID()).equals(entityCitizen.getUUID())) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizentrack.success.disable"), true);
            PathfindingUtils.trackingMap.remove(sender.getUUID());
            new SyncPathMessage(new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>(), new HashSet<MNode>()).sendToPlayer((ServerPlayer)sender);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizentrack.success.enable"), true);
            PathfindingUtils.trackingMap.put(sender.getUUID(), entityCitizen.getUUID());
        }
        return 1;
    }

    @Override
    public String getName() {
        return "trackPath";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", ColonyIdArgument.id()).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

