/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.compatibility.journeymap;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.eventbus.events.colony.ColonyViewUpdatedModEvent;
import com.minecolonies.core.compatibility.journeymap.ColonyBorderMapping;
import com.minecolonies.core.compatibility.journeymap.ColonyDeathpoints;
import com.minecolonies.core.compatibility.journeymap.Journeymap;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.ChunkEvent;
import org.jetbrains.annotations.NotNull;

public class EventListener {
    @NotNull
    private final Journeymap jmap;
    private boolean viewsUpdated;

    public EventListener(@NotNull Journeymap jmap) {
        this.jmap = jmap;
        NeoForge.EVENT_BUS.register((Object)this);
        IMinecoloniesAPI.getInstance().getEventBus().subscribe(ColonyViewUpdatedModEvent.class, this::onColonyViewUpdated);
    }

    @SubscribeEvent
    public void onPlayerLogout(@NotNull ClientPlayerNetworkEvent.LoggingOut event) {
        ColonyDeathpoints.clear();
        this.jmap.getApi().removeAll("minecolonies");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onChunkLoaded(@NotNull ChunkEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            ResourceKey dimension = level.dimension();
            ColonyBorderMapping.updateChunk(this.jmap, (ResourceKey<Level>)dimension, event.getChunk());
            ColonyDeathpoints.updateChunk(this.jmap, (ResourceKey<Level>)dimension, event.getChunk());
        }
    }

    public void onColonyViewUpdated(@NotNull ColonyViewUpdatedModEvent event) {
        IColonyView colony = event.getColony();
        Set<BlockPos> graves = colony.getGraveManager().getGraves().keySet();
        this.viewsUpdated = true;
        ColonyDeathpoints.updateGraves(this.jmap, colony, graves);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onClientTick(@NotNull ClientTickEvent.Pre event) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null) {
            if (this.viewsUpdated) {
                this.viewsUpdated = false;
                ColonyBorderMapping.queueChunks(this.jmap, (ResourceKey<Level>)world.dimension());
            }
            ColonyBorderMapping.updatePending(this.jmap, (ResourceKey<Level>)world.dimension());
        }
    }
}

