/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener;

import com.google.gson.JsonObject;
import com.minecolonies.core.datalistener.BaseDataListener;
import com.minecolonies.core.datalistener.model.StudyItem;
import com.minecolonies.core.datalistener.util.MappingResult;
import com.minecolonies.core.util.GsonHelper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class StudyItemListener
extends BaseDataListener<StudyItem> {
    public static final StudyItemListener INSTANCE = new StudyItemListener();

    private StudyItemListener() {
        super("study_items");
    }

    @Override
    @NotNull
    protected MappingResult<StudyItem> mapEntry(ResourceLocation key, JsonObject object) {
        Item item = (Item)BuiltInRegistries.ITEM.get(GsonHelper.getAsResourceLocation(object, "item"));
        int skillIncreaseChance = Mth.clamp((int)GsonHelper.getAsInt((JsonObject)object, (String)"skill_increase_chance", (int)1), (int)1, (int)100);
        int breakChance = Mth.clamp((int)GsonHelper.getAsInt((JsonObject)object, (String)"break_chance", (int)1), (int)1, (int)100);
        return MappingResult.ok(new StudyItem(item, skillIncreaseChance, breakChance));
    }
}

