/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.debug.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.debug.messages.DebugEnablePathfindingMessage;
import com.minecolonies.core.debug.messages.QueryCitizenAIHistoryMessage;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class DebugWindowCitizen
extends AbstractWindowSkeleton {
    public static MutableComponent outputMessage = Component.empty();
    private static boolean trackingDebug = false;

    public DebugWindowCitizen(ICitizenDataView citizen) {
        super(new ResourceLocation("minecolonies", "gui/citizen/debug.xml"));
        if (Objects.equals(outputMessage, Component.empty())) {
            outputMessage = Component.literal((String)"Enabled Citizen AI History!");
        }
        ((Text)this.findPaneOfTypeByID("citizenid", Text.class)).setText(Component.literal((String)("Citizen ID:" + citizen.getId())));
        ((Text)this.findPaneOfTypeByID("colonyid", Text.class)).setText(Component.literal((String)("Colony ID:" + citizen.getColonyId())));
        ((Button)this.findPaneOfTypeByID("aihistory", Button.class)).setHandler(b -> new QueryCitizenAIHistoryMessage(citizen).sendToServer());
        ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setHandler(b -> {
            boolean bl = trackingDebug = !trackingDebug;
            if (trackingDebug) {
                outputMessage = Component.literal((String)"Receiving pathfinding data");
            }
            new DebugEnablePathfindingMessage(citizen, trackingDebug).sendToServer();
            ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setText(Component.literal((String)(trackingDebug ? "disable Pathfinding tracking" : "enable Pathfinding tracking")));
        });
        ((Button)this.findPaneOfTypeByID("pathfinding", Button.class)).setText(Component.literal((String)(trackingDebug ? "disable Pathfinding tracking" : "enable Pathfinding tracking")));
    }

    public void onUpdate() {
        super.onUpdate();
        ((Text)this.findPaneOfTypeByID("output", Text.class)).setText(outputMessage);
    }
}

