/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EntityAIInteractToggleAble
extends Goal {
    private static final int DEFAULT_HEIGHT_TO_CHECK = 2;
    private static final int LENGTH_TO_CHECK = 2;
    private static final double MIN_DISTANCE = 4.0;
    private static final double MAX_DISTANCE = 5.0;
    public static final ToggleAble FENCE_TOGGLE = new FenceToggle();
    public static final ToggleAble TRAP_TOGGLE = new TrapToggle();
    public static final ToggleAble DOOR_TOGGLE = new DoorToggle();
    protected AbstractFastMinecoloniesEntity entity;
    private Map<BlockPos, Boolean> toggleAblePositions = new HashMap<BlockPos, Boolean>();
    private final List<ToggleAble> toggleAbles;
    private final List<ToggleAble> myToggled;
    private int updateTimer = 0;
    private int executeTimerSlow = 60;
    private final int offSet;

    public EntityAIInteractToggleAble(@NotNull AbstractFastMinecoloniesEntity entityIn, ToggleAble ... toggleAbles) {
        this.entity = entityIn;
        this.toggleAbles = Arrays.asList(toggleAbles);
        this.myToggled = new ArrayList<ToggleAble>();
        if (!(entityIn.getNavigation() instanceof GroundPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for EntityAIInteractToggleAble");
        }
        this.offSet = entityIn.level().random.nextInt(20);
    }

    public boolean canUse() {
        if ((this.entity.hadHorizontalCollission() || this.entity.verticalCollision && !this.entity.onGround()) && this.updateTimer-- <= 0) {
            this.updateTimer = 10;
            return this.checkPath();
        }
        if (this.executeTimerSlow-- <= 0) {
            this.executeTimerSlow = 50;
            return this.checkPathBlocksBelow();
        }
        return false;
    }

    public void start() {
        super.start();
        this.updateTimer = 0;
    }

    private boolean checkPath() {
        @NotNull GroundPathNavigation pathnavigateground = (GroundPathNavigation)this.entity.getNavigation();
        Path path = pathnavigateground.getPath();
        this.checkPathBlocksCollided(path);
        return !this.toggleAblePositions.isEmpty();
    }

    private void checkPathBlocksCollided(Path path) {
        if (path == null || path.isDone()) {
            this.resetAll();
            return;
        }
        int maxLengthToCheck = Math.min(path.getNextNodeIndex() + 2, path.getNodeCount());
        for (int i = Math.max(0, path.getNextNodeIndex() - 2); i < maxLengthToCheck; ++i) {
            if (i == path.getNodeCount() - 1) {
                return;
            }
            Node current = path.getNode(i);
            Node next = path.getNode(i + 1);
            if (next.x == current.x && next.y == current.y && next.z == current.z) continue;
            Direction dir = current.x == next.x && current.z == next.z ? Direction.EAST : BlockPosUtil.directionFromDelta(next.x - current.x, 0, next.z - current.z);
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(current.x, current.y + level, current.z));
                this.checkPosAndAdd((Entity)this.entity, dir, new BlockPos(next.x, next.y + level, next.z));
            }
        }
    }

    private void checkPosAndAdd(Entity entity, Direction dir, BlockPos pos) {
        VoxelShape collisionShape;
        if (this.toggleAblePositions.containsKey(pos)) {
            return;
        }
        BlockState state = entity.level().getBlockState(pos);
        if (this.entity.distanceToSqr(pos.getX(), this.entity.getY(), pos.getZ()) <= 4.0 && this.isValidBlockState(state) && (collisionShape = state.getCollisionShape((BlockGetter)entity.level(), pos)).min((dir = dir.getClockWise()).getAxis()) + 0.1 < (double)entity.getBbWidth() && collisionShape.max(dir.getAxis()) + 0.1 + (double)entity.getBbWidth() > 1.0) {
            this.toggleAblePositions.put(pos, (Boolean)state.getValue((Property)BlockStateProperties.OPEN));
        }
    }

    private boolean checkPathBlocksBelow() {
        @NotNull GroundPathNavigation pathnavigateground = (GroundPathNavigation)this.entity.getNavigation();
        Path path = pathnavigateground.getPath();
        if (path == null || path.isDone()) {
            this.resetAll();
            return false;
        }
        int maxLengthToCheck = Math.min(path.getNextNodeIndex() + 2, path.getNodeCount());
        for (int i = Math.max(0, path.getNextNodeIndex() - 2); i < maxLengthToCheck; ++i) {
            Node pathpoint = path.getNode(i);
            for (int level = 0; level < this.getHeightToCheck(path, i); ++level) {
                BlockPos pos = new BlockPos(pathpoint.x, pathpoint.y + level, pathpoint.z);
                if (!this.entity.blockPosition().equals((Object)pos) && !this.entity.blockPosition().below().equals((Object)pos)) continue;
                BlockState state = this.entity.level().getBlockState(pos);
                if (!(this.entity.distanceToSqr(pos.getX(), this.entity.getY(), pos.getZ()) <= 4.0) || !this.isValidBlockState(state)) continue;
                if (level > 0) {
                    this.toggleAblePositions.put(pos, (Boolean)this.entity.level().getBlockState(pos).getValue((Property)BlockStateProperties.OPEN));
                    continue;
                }
                if (i >= path.getNodeCount() - 1) continue;
                Node nextPoint = path.getNode(i + 1);
                if ((pos.getX() != nextPoint.x || pos.getY() <= nextPoint.y || pos.getZ() != nextPoint.z) && !(this.entity.getY() - (double)pos.getY() > 1.0)) continue;
                this.toggleAblePositions.put(pos, (Boolean)this.entity.level().getBlockState(pos).getValue((Property)BlockStateProperties.OPEN));
            }
        }
        return !this.toggleAblePositions.isEmpty();
    }

    private int getHeightToCheck(Path path, int index) {
        if (path == null || index < 0 || index >= path.getNodeCount()) {
            return 2;
        }
        Node current = path.getNode(index);
        int prevDist = 0;
        if (index > 0) {
            Node prev = path.getNode(index - 1);
            prevDist = prev.y - current.y;
        }
        int nextDist = 0;
        if (index + 1 < path.getNodeCount()) {
            Node next = path.getNode(index + 1);
            nextDist = next.y - current.y;
        }
        return Math.max(2, 2 + Math.max(prevDist, nextDist));
    }

    public boolean canContinueToUse() {
        return !this.toggleAblePositions.isEmpty();
    }

    private void resetAll() {
        block0: for (BlockPos pos : this.toggleAblePositions.keySet()) {
            for (ToggleAble toggleAble : this.toggleAbles) {
                BlockState state;
                if (!toggleAble.isBlockToggleAble(state = this.entity.level().getBlockState(pos)) || toggleAble.onlyCloseYourOpens() && !this.myToggled.contains(toggleAble)) continue;
                toggleAble.toggleBlockClosed((Entity)this.entity, state, this.entity.level(), pos);
                this.myToggled.remove(toggleAble);
                continue block0;
            }
        }
        this.toggleAblePositions.clear();
        this.myToggled.clear();
        this.updateTimer = 0;
    }

    private boolean isValidBlockState(BlockState state) {
        if (state.getBlock() == Blocks.AIR) {
            return false;
        }
        for (ToggleAble toggleAble : this.toggleAbles) {
            if (!toggleAble.isBlockToggleAble(state) || !state.hasProperty((Property)BlockStateProperties.OPEN)) continue;
            return true;
        }
        return false;
    }

    public void tick() {
        BlockState state;
        if (--this.updateTimer >= 0) {
            return;
        }
        this.updateTimer = ColonyConstants.rand.nextInt(40 + this.offSet);
        if (!this.checkPath()) {
            return;
        }
        Iterator<BlockPos> it = this.toggleAblePositions.keySet().iterator();
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        block0: while (it.hasNext()) {
            BlockPos pos = it.next();
            state = this.entity.level().getBlockState(pos);
            if (!this.isValidBlockState(state)) {
                it.remove();
                continue;
            }
            if (this.entity.distanceToSqr(pos.getX(), pos.getY(), pos.getZ()) > 5.0) {
                it.remove();
                BlockState blockState = this.entity.level().getBlockState(pos);
                for (ToggleAble toggleAble : this.toggleAbles) {
                    if (!toggleAble.isBlockToggleAble(blockState) || toggleAble.onlyCloseYourOpens() && !this.myToggled.contains(toggleAble)) continue;
                    toggleAble.toggleBlockClosed((Entity)this.entity, blockState, this.entity.level(), pos);
                    this.myToggled.remove(toggleAble);
                    continue block0;
                }
                continue;
            }
            posList.add(pos);
        }
        if (!posList.isEmpty()) {
            BlockPos chosen = (BlockPos)posList.get(this.entity.level().random.nextInt(posList.size()));
            state = this.entity.level().getBlockState(chosen);
            for (ToggleAble toggleAble : this.toggleAbles) {
                if (!toggleAble.isBlockToggleAble(state) || !toggleAble.canOpen(state)) continue;
                toggleAble.toggleBlock((Entity)this.entity, state, this.entity.level(), chosen);
                this.myToggled.add(toggleAble);
                break;
            }
        }
    }

    public static abstract class ToggleAble {
        public abstract boolean isBlockToggleAble(BlockState var1);

        public boolean canOpen(BlockState state) {
            return this.isBlockToggleAble(state);
        }

        public boolean onlyCloseYourOpens() {
            return false;
        }

        public abstract void toggleBlock(Entity var1, BlockState var2, Level var3, BlockPos var4);

        public abstract void toggleBlockClosed(Entity var1, BlockState var2, Level var3, BlockPos var4);
    }

    private static class FenceToggle
    extends ToggleAble {
        private FenceToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.getBlock() instanceof FenceGateBlock;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.cycle((Property)BlockStateProperties.OPEN));
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static class TrapToggle
    extends ToggleAble {
        private TrapToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.getBlock() instanceof TrapDoorBlock;
        }

        @Override
        public boolean canOpen(BlockState state) {
            return (Boolean)state.getValue((Property)BlockStateProperties.OPEN) == false;
        }

        @Override
        public boolean onlyCloseYourOpens() {
            return true;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.cycle((Property)BlockStateProperties.OPEN));
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static class DoorToggle
    extends ToggleAble {
        private DoorToggle() {
        }

        @Override
        public boolean isBlockToggleAble(BlockState state) {
            return state.getBlock() instanceof DoorBlock;
        }

        @Override
        public void toggleBlock(Entity entity, BlockState state, Level world, BlockPos pos) {
            if (state.getBlock().getClass() == DoorBlock.class) {
                boolean isOpening = (Boolean)state.getValue((Property)BlockStateProperties.OPEN) == false;
                WorldUtil.setBlockState((LevelAccessor)world, pos, (BlockState)state.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(isOpening)), 10);
                BlockPos otherPos = state.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
                BlockState otherState = world.getBlockState(otherPos);
                if (otherState.getBlock().getClass() == DoorBlock.class) {
                    WorldUtil.setBlockState((LevelAccessor)world, otherPos, (BlockState)otherState.setValue((Property)FenceGateBlock.OPEN, (Comparable)Boolean.valueOf(isOpening)), 10);
                }
                ((DoorBlock)state.getBlock()).playSound(entity, world, pos, isOpening);
            } else {
                ((DoorBlock)state.getBlock()).setOpen(entity, world, state, pos, (Boolean)state.getValue((Property)BlockStateProperties.OPEN) == false);
            }
        }

        @Override
        public void toggleBlockClosed(Entity entity, BlockState state, Level world, BlockPos pos) {
            ((DoorBlock)state.getBlock()).setOpen(entity, world, state, pos, false);
        }
    }
}

