/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.tileentities.TileEntityColonySign;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemColonySign
extends BlockItem {
    public ItemColonySign(Item.Properties properties) {
        super(ModBlocks.blockColonySign, properties.stacksTo(64));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockEntity entity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        BlockState state = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (ctx.getPlayer().isShiftKeyDown()) {
            if (state.getBlock() == ModBlocks.blockHutGateHouse && entity instanceof TileEntityColonyBuilding) {
                TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
                if (!ctx.getLevel().isClientSide) {
                    if (buildingEntity.getColony() == null) {
                        MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.getPlayer());
                        return InteractionResult.SUCCESS;
                    }
                    if (buildingEntity.getBuilding() != null && buildingEntity.getBuilding().getBuildingLevel() <= 0) {
                        MessageUtils.format("com.minecolonies.core.item.sign.badgatehouse", new Object[0]).sendTo(ctx.getPlayer());
                        return InteractionResult.SUCCESS;
                    }
                    ColonyId colonyComponent = ColonyId.readFromItemStack(ctx.getItemInHand());
                    if (colonyComponent.hasColonyId() && colonyComponent.id() != buildingEntity.getColonyId()) {
                        IColony sourceColony = IColonyManager.getInstance().getColonyByDimension(colonyComponent.id(), (ResourceKey<Level>)ctx.getLevel().dimension());
                        if (sourceColony == null) {
                            MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.getPlayer());
                            return InteractionResult.SUCCESS;
                        }
                        if (!sourceColony.getPermissions().hasPermission(ctx.getPlayer(), Action.MANAGE_HUTS)) {
                            MessageUtils.format("com.minecolonies.core.item.sign.noperm", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
                            return InteractionResult.SUCCESS;
                        }
                        sourceColony.getConnectionManager().attemptEstablishConnection(ctx.getClickedPos(), buildingEntity.getColony());
                        return InteractionResult.SUCCESS;
                    }
                    if (buildingEntity.getColony().getPermissions().hasPermission(ctx.getPlayer(), Action.MANAGE_HUTS)) {
                        buildingEntity.getColony().writeToItemStack(ctx.getItemInHand());
                        new BuildingId(ctx.getClickedPos()).writeToItemStack(ctx.getItemInHand());
                        MessageUtils.format("com.minecolonies.core.item.sign.registered", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
                    } else {
                        MessageUtils.format("com.minecolonies.core.item.sign.noperm", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof TileEntityColonySign) {
                TileEntityColonySign signEntity = (TileEntityColonySign)entity;
                if (!ctx.getLevel().isClientSide) {
                    IColony colony = IColonyManager.getInstance().getColonyByDimension(signEntity.getColonyId(), (ResourceKey<Level>)ctx.getLevel().dimension());
                    if (colony == null) {
                        MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.getPlayer());
                        return InteractionResult.SUCCESS;
                    }
                    ColonyId colonyComponent = ColonyId.readFromItemStack(ctx.getItemInHand());
                    if (colonyComponent.hasColonyId() && colonyComponent.id() != signEntity.getColonyId()) {
                        IColony sourceColony = IColonyManager.getInstance().getColonyByDimension(colonyComponent.id(), (ResourceKey<Level>)ctx.getLevel().dimension());
                        if (sourceColony == null) {
                            MessageUtils.format("com.minecolonies.core.item.sign.nullcolony", new Object[0]).sendTo(ctx.getPlayer());
                            return InteractionResult.SUCCESS;
                        }
                        if (!sourceColony.getPermissions().hasPermission(ctx.getPlayer(), Action.MANAGE_HUTS)) {
                            MessageUtils.format("com.minecolonies.core.item.sign.noperm", sourceColony.getName()).sendTo(ctx.getPlayer());
                            return InteractionResult.SUCCESS;
                        }
                        sourceColony.getConnectionManager().attemptEstablishConnection(ctx.getClickedPos(), colony);
                        return InteractionResult.SUCCESS;
                    }
                    if (colony.getPermissions().hasPermission(ctx.getPlayer(), Action.MANAGE_HUTS)) {
                        colony.writeToItemStack(ctx.getItemInHand());
                        new BuildingId(ctx.getClickedPos()).writeToItemStack(ctx.getItemInHand());
                        MessageUtils.format("com.minecolonies.core.item.sign.registered", colony.getName()).sendTo(ctx.getPlayer());
                    } else {
                        MessageUtils.format("com.minecolonies.core.item.sign.noperm", colony.getName()).sendTo(ctx.getPlayer());
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(ctx);
    }

    protected boolean canPlace(BlockPlaceContext ctx, BlockState state) {
        if (!super.canPlace(ctx, state)) {
            return false;
        }
        ColonyId colonyComponent = ColonyId.readFromItemStack(ctx.getItemInHand());
        if (!colonyComponent.hasColonyId()) {
            if (ctx.getLevel().isClientSide) {
                MessageUtils.format("com.minecolonies.core.item.sign.toofar", new Object[0]).sendTo(ctx.getPlayer());
            }
            return false;
        }
        if (!ctx.getLevel().isClientSide) {
            int colonyId = colonyComponent.id();
            IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyId, (ResourceKey<Level>)ctx.getLevel().dimension());
            if (colony == null) {
                MessageUtils.format("com.minecolonies.core.item.sign.toofar", new Object[0]).sendTo(ctx.getPlayer());
                return false;
            }
            if (colony.getConnectionManager().addNewConnectionNode(ctx.getClickedPos())) {
                SoundUtils.playSuccessSound(ctx.getPlayer(), ctx.getClickedPos());
                return true;
            }
            SoundUtils.playErrorSound(ctx.getPlayer(), ctx.getClickedPos());
            return false;
        }
        return true;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        ColonyId colonyComponent = ColonyId.readFromItemStack(stack);
        if (colonyComponent.hasColonyId()) {
            MutableComponent colonyHint = Component.translatable((String)"com.minecolonies.core.item.colonysign.tip.colony", (Object[])new Object[]{colonyComponent.id()});
            colonyHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_BLUE));
            tooltip.add((Component)colonyHint);
        }
        MutableComponent guiHint = Component.translatable((String)"com.minecolonies.core.item.colonysign.tip");
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
    }
}

