/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final int RED_OVERLAY = -65536;
    private static final int GREEN_OVERLAY = -16711936;

    public ItemScepterLumberjack(Item.Properties properties) {
        super("scepterlumberjack", properties.stacksTo(1).component((Supplier)ModDataComponents.POS_SELECTION, (Object)AbstractItemWithPosSelector.PosSelection.EMPTY));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        ItemStack scepter = context.getPlayer().getItemInHand(context.getHand());
        MessageUtils.format("item.minecolonies.scepterlumberjack.usedstart", new Object[0]).sendTo(context.getPlayer());
        AbstractItemWithPosSelector.PosSelection.updateItemStack((ItemStack)scepter, selection -> selection.setStartPos(context.getClickedPos()));
        this.storeRestrictedArea(context.getPlayer(), scepter, context.getLevel());
        return InteractionResult.FAIL;
    }

    public boolean canAttackBlock(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player) {
        if (!world.isClientSide) {
            ItemStack scepter = player.getMainHandItem();
            MessageUtils.format("item.minecolonies.scepterlumberjack.usedend", new Object[0]).sendTo(player);
            AbstractItemWithPosSelector.PosSelection.updateItemStack((ItemStack)scepter, selection -> selection.setEndpos(pos));
            this.storeRestrictedArea(player, scepter, world);
        }
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    private void storeRestrictedArea(Player player, ItemStack scepter, Level worldIn) {
        int maxVolume;
        int maxZ;
        int distZ;
        int maxY;
        int distY;
        AbstractItemWithPosSelector.PosSelection component = AbstractItemWithPosSelector.PosSelection.readFromItemStack((ItemStack)scepter);
        Tuple<BlockPos, BlockPos> box = this.getBox(worldIn, scepter, component);
        if (box == null) {
            return;
        }
        assert (box.getA() != null && box.getB() != null);
        int minX = Math.min(box.getA().getX(), box.getB().getX());
        int minY = Math.min(box.getA().getY(), box.getB().getY());
        int minZ = Math.min(box.getA().getZ(), box.getB().getZ());
        int maxX = Math.max(box.getA().getX(), box.getB().getX());
        int distX = maxX - minX;
        int volume = distX * (distY = (maxY = Math.max(box.getA().getY(), box.getB().getY())) - minY) * (distZ = (maxZ = Math.max(box.getA().getZ(), box.getB().getZ())) - minZ);
        if (volume > (maxVolume = (int)Math.floor(2.0 * Math.pow(50.0, 3.0)))) {
            MessageUtils.format("item.minecolonies.scepterlumberjack.restrictiontoobig", volume, maxVolume).sendTo(player);
            return;
        }
        IBuilding iBuilding = BuildingId.readBuildingFromItemStack(scepter);
        if (!(iBuilding instanceof BuildingLumberjack)) {
            return;
        }
        BuildingLumberjack hut = (BuildingLumberjack)iBuilding;
        MessageUtils.format("item.minecolonies.scepterlumberjack.restrictionset", minX, maxX, minY, maxY, minZ, maxZ, volume, maxVolume).sendTo(player);
        hut.setRestrictedArea(box.getA(), box.getB());
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        AbstractItemWithPosSelector.PosSelection component = AbstractItemWithPosSelector.PosSelection.readFromItemStack((ItemStack)stack);
        BuildingId buildingId = BuildingId.readFromItemStack(stack);
        Tuple<BlockPos, BlockPos> box = this.getBox(world, stack, component);
        if (buildingId.hasId()) {
            IBlockOverlayItem.OverlayBox anchorBox = new IBlockOverlayItem.OverlayBox(buildingId.id(), -65536, 0.02f, true);
            if (box != null && box.getA() != null && box.getB() != null) {
                AABB bounds = AABB.encapsulatingFullBlocks((BlockPos)box.getA(), (BlockPos)box.getB().offset(1, 1, 1)).inflate(1.0);
                return List.of(anchorBox, new IBlockOverlayItem.OverlayBox(bounds, -16711936, 0.02f, true));
            }
            return Collections.singletonList(anchorBox);
        }
        return Collections.emptyList();
    }

    @Nullable
    private Tuple<BlockPos, BlockPos> getBox(@NotNull Level world, ItemStack stack, AbstractItemWithPosSelector.PosSelection selection) {
        BlockPos start = selection.startPos().orElse(null);
        BlockPos end = selection.endPos().orElse(null);
        if (world.isClientSide()) {
            return new Tuple<BlockPos, BlockPos>(start, end);
        }
        IBuilding iBuilding = BuildingId.readBuildingFromItemStack(stack);
        if (iBuilding instanceof BuildingLumberjack) {
            BlockPos endRestriction;
            BuildingLumberjack hut = (BuildingLumberjack)iBuilding;
            BlockPos startRestriction = start != null ? start : Objects.requireNonNullElse(hut.getStartRestriction(), BlockPos.ZERO);
            BlockPos blockPos = endRestriction = end != null ? end : Objects.requireNonNullElse(hut.getEndRestriction(), BlockPos.ZERO);
            if (!startRestriction.equals((Object)BlockPos.ZERO) && !endRestriction.equals((Object)BlockPos.ZERO)) {
                return new Tuple<BlockPos, BlockPos>(startRestriction, endRestriction);
            }
        }
        return null;
    }
}

