/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.settings.GuardFollowModeSetting;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.AbstractAISkeleton;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemScrollGuardHelp
extends AbstractItemScroll {
    public ItemScrollGuardHelp(Item.Properties properties) {
        super("scroll_guard_help", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        IBuilding iBuilding = BuildingId.readBuildingFromItemStack(itemStack);
        if (!(iBuilding instanceof AbstractBuildingGuards)) {
            MessageUtils.format("minecolonies.scroll.noguardbuilding", new Object[0]).sendTo(new Player[]{player});
            return itemStack;
        }
        AbstractBuildingGuards building = (AbstractBuildingGuards)iBuilding;
        itemStack.shrink(1);
        IColony colony = building.getColony();
        ArrayList<ICitizenData> guards = new ArrayList<ICitizenData>(building.getAllAssignedCitizen());
        if (world.random.nextInt(10) == 0 || colony.getWorld() != world) {
            Llama entity = (Llama)EntityType.LLAMA.create(world);
            entity.setPos(player.getX(), player.getY(), player.getZ());
            world.addFreshEntity((Entity)entity);
            player.displayClientMessage((Component)Component.translatableEscape((String)("minecolonies.scroll.failed" + (world.random.nextInt(10) + 1)), (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            SoundUtils.playSoundForPlayer(player, SoundEvents.EVOKER_CAST_SPELL, 0.5f, 1.0f);
            return itemStack;
        }
        for (ICitizenData citizenData : guards) {
            AbstractJobGuard job = citizenData.getJob(AbstractJobGuard.class);
            if (job != null && job.getWorkerAI() != null && !((AbstractEntityAIGuard)job.getWorkerAI()).hasTool()) continue;
            if (citizenData.getEntity().isPresent()) {
                if (citizenData.getCitizenDiseaseHandler().isSick()) continue;
                citizenData.getEntity().get().remove(Entity.RemovalReason.DISCARDED);
            }
            colony.getCitizenManager().spawnOrCreateCivilian(citizenData, world, player.blockPosition(), true);
            citizenData.setNextRespawnPosition(building.getID());
            building.getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.follow");
            building.setPlayerToFollow((Player)player);
            GuardFollowModeSetting grouping = building.getSetting(AbstractBuildingGuards.FOLLOW_MODE);
            if (grouping.getValue().equals("com.minecolonies.core.guard.setting.follow.loose")) {
                grouping.trigger();
            }
            citizenData.setSaturation(100.0);
            colony.getPackageManager().addCloseSubscriber(player);
            if (job == null || job.getWorkerAI() == null) continue;
            long spawnTime = world.getGameTime() + 18000L;
            ((AbstractAISkeleton)job.getWorkerAI()).registerTarget(new AIOneTimeEventTarget<IAIState>(() -> {
                if (world.getGameTime() - spawnTime > 0L) {
                    building.getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                    citizenData.getEntity().ifPresent(e -> e.remove(Entity.RemovalReason.DISCARDED));
                    colony.getPackageManager().removeCloseSubscriber(player);
                    return true;
                }
                return false;
            }, AIWorkerState.DECIDE));
        }
        SoundUtils.playSoundForPlayer(player, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, 0.3f, 1.0f);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    @Override
    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        IBuilding building;
        InteractionResult result = super.useOn(ctx);
        if (ctx.getLevel().isClientSide) {
            return result;
        }
        BlockEntity te = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (te instanceof TileEntityColonyBuilding && ctx.getPlayer() != null && !((building = ((TileEntityColonyBuilding)te).getColony().getBuildingManager().getBuilding(ctx.getClickedPos())) instanceof AbstractBuildingGuards)) {
            MessageUtils.format("minecolonies.scroll.noguardbuilding", new Object[0]).sendTo(ctx.getPlayer());
        }
        return result;
    }

    public void onUseTick(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.isClientSide && worldIn.getGameTime() % 5L == 0L) {
            LivingEntity entity1 = entity;
            new VanillaParticleMessage(entity.getX(), entity.getY(), entity.getZ(), ParticleTypes.ENCHANT).sendToTrackingEntity((Entity)entity1);
            new VanillaParticleMessage(entity.getX(), entity.getY(), entity.getZ(), ParticleTypes.ENCHANT).sendToPlayer((ServerPlayer)entity);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"item.minecolonies.scroll_guard_help.tip", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        String colonyDesc = Component.translatableEscape((String)"item.minecolonies.scroll.colony.none", (Object[])new Object[0]).getString();
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = colony.getName();
        }
        MutableComponent guiHint2 = Component.translatableEscape((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

