/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.content.capabilities.CoreCapabilities;
import tv.soaryn.xycraft.core.content.capabilities.WrenchCapability;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

@EventBusSubscriber(modid="xycraft_world", bus=EventBusSubscriber.Bus.MOD)
public class AureyBlock
extends ColoredBlock {
    private final DyeColors _dyeColor;

    public AureyBlock(DyeColors color, BlockBehaviour.Properties properties) {
        super((IColorSource)color, properties.instabreak());
        this._dyeColor = color;
    }

    public static AureyBlock glow(DyeColors color, BlockBehaviour.Properties properties) {
        return new AureyBlock(color, properties.lightLevel(v -> 15));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumMap<DyeColors, BlockContent> getCurrentMap(int light, BlockState state) {
        EnumMap<DyeColors, BlockContent> currentMap;
        EnumMap<DyeColors, BlockContent> enumMap = currentMap = light > 0 ? WorldContent.Block.AureyBlockMatteGlowing : WorldContent.Block.AureyBlockMatte;
        if (light > 0) {
            if (WorldContent.Block.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                return WorldContent.Block.AureyBlockFxGlowing;
            }
        }
        if (!WorldContent.Block.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) return currentMap;
        return WorldContent.Block.AureyBlockFx;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, Player player) {
        if (player.isCreative()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        EnumMap<DyeColors, BlockContent> currentMap = state.getLightEmission((BlockGetter)level, pos) > 0 ? WorldContent.Block.AureyBlockMatteGlowing : WorldContent.Block.AureyBlockMatte;
        return new ItemStack((ItemLike)currentMap.get(DyeColors.Pink).block(), 1);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        ItemInteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand);
        if (interactionResult != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return interactionResult;
        }
        if (WrenchCapability.isValidToolInMainHand((Player)player, (InteractionHand)hand, (boolean)true)) {
            boolean wasLight = false;
            EnumMap<DyeColors, BlockContent> map = WorldContent.Block.AureyBlockMatte;
            if (WorldContent.Block.AureyBlockMatte.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                map = WorldContent.Block.AureyBlockFx;
            } else if (WorldContent.Block.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                wasLight = true;
                map = player.isShiftKeyDown() ? WorldContent.Block.AureyBlockMatte : WorldContent.Block.AureyBlockFxGlowing;
            } else if (WorldContent.Block.AureyBlockFxGlowing.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                wasLight = true;
                EnumMap<DyeColors, BlockContent> enumMap = map = player.isShiftKeyDown() ? WorldContent.Block.AureyBlockFx : WorldContent.Block.AureyBlockMatteGlowing;
            }
            if (wasLight && player.isShiftKeyDown()) {
                if (!player.isCreative()) {
                    Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)hit.getDirection(), (ItemStack)new ItemStack((ItemLike)Items.GLOW_INK_SAC));
                }
                level.setBlockAndUpdate(pos, map.get(this._dyeColor).block().withPropertiesOf(state));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (!player.isShiftKeyDown()) {
                level.setBlockAndUpdate(pos, map.get(this._dyeColor).block().withPropertiesOf(state));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (stack.getItem() == Items.GLOW_INK_SAC) {
            if (WorldContent.Block.AureyBlockMatteGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                if (WorldContent.Block.AureyBlockFxGlowing.values().stream().map(BlockContent::block).noneMatch(arg_0 -> ((BlockState)state).is(arg_0))) {
                    EnumMap<DyeColors, BlockContent> currentMap;
                    EnumMap<DyeColors, BlockContent> enumMap = currentMap = WorldContent.Block.AureyBlockFx.values().stream().map(BlockContent::block).anyMatch(arg_0 -> ((BlockState)state).is(arg_0)) ? WorldContent.Block.AureyBlockFxGlowing : WorldContent.Block.AureyBlockMatteGlowing;
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                    }
                    stack.shrink(player.isCreative() ? 0 : 1);
                    level.setBlockAndUpdate(pos, currentMap.get(this._dyeColor).block().withPropertiesOf(state));
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        Player player = context.getPlayer();
        if (player != null) {
            ItemStack offhandStack = context.getHand() == InteractionHand.OFF_HAND ? player.getMainHandItem() : player.getOffhandItem();
            int light = state.getLightEmission((BlockGetter)context.getLevel(), context.getClickedPos());
            DyeColor color = DyeColor.getColor((ItemStack)offhandStack);
            if (color != null) {
                state = this.getCurrentMap(light, state).get(DyeColors.from((DyeColor)color)).block().defaultBlockState();
            }
        }
        return (BlockState)state.setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false));
    }

    private static <T extends Enum<T>> Block[] getFromMap(EnumMap<T, BlockContent> map) {
        return (Block[])map.values().stream().map(BlockContent::block).toArray(Block[]::new);
    }

    @SubscribeEvent
    private static void attachBlockEntity(RegisterCapabilitiesEvent event) {
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColoredBlock.dyeColorCap(WorldContent.Block.AureyBlockMatte), AureyBlock.getFromMap(WorldContent.Block.AureyBlockMatte));
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColoredBlock.dyeColorCap(WorldContent.Block.AureyBlockMatteGlowing), AureyBlock.getFromMap(WorldContent.Block.AureyBlockMatteGlowing));
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColoredBlock.dyeColorCap(WorldContent.Block.AureyBlockFx), AureyBlock.getFromMap(WorldContent.Block.AureyBlockFx));
        event.registerBlock(CoreCapabilities.Colorable.BLOCK, ColoredBlock.dyeColorCap(WorldContent.Block.AureyBlockFxGlowing), AureyBlock.getFromMap(WorldContent.Block.AureyBlockFxGlowing));
    }
}

