/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.generation;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.jetbrains.annotations.NotNull;
import tv.soaryn.xycraft.world.content.generation.HarvestableNodeStructure;
import tv.soaryn.xycraft.world.content.generation.SurfaceGeyserPiece;
import tv.soaryn.xycraft.world.content.registries.WorldStructures;

public class SurfaceGeyserStructure
extends HarvestableNodeStructure {
    public static final MapCodec<SurfaceGeyserStructure> CODEC = SurfaceGeyserStructure.makeCodec(SurfaceGeyserStructure::new);

    public SurfaceGeyserStructure(BlockStateProvider blockStateProvider, FloatProvider clearanceRadius, FloatProvider clearanceHeight, Structure.StructureSettings settings) {
        super(blockStateProvider, clearanceRadius, clearanceHeight, settings);
    }

    @Override
    protected Optional<BlockPos> getStartPos(Structure.GenerationContext context, WorldgenRandom random) {
        int placeX = SectionPos.sectionToBlockCoord((int)context.chunkPos().x, (int)random.nextInt(16));
        int placeZ = SectionPos.sectionToBlockCoord((int)context.chunkPos().z, (int)random.nextInt(16));
        int firstOccupiedHeight = context.chunkGenerator().getFirstOccupiedHeight(placeX, placeZ, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        return firstOccupiedHeight < context.chunkGenerator().getSeaLevel() ? Optional.empty() : Optional.of(new BlockPos(placeX, firstOccupiedHeight, placeZ));
    }

    @Override
    protected Consumer<StructurePiecesBuilder> createStructure(BlockPos center, BlockState blockWell, float radius, float height) {
        return structurePiecesBuilder -> structurePiecesBuilder.addPiece((StructurePiece)new SurfaceGeyserPiece(center, blockWell, radius, height));
    }

    @NotNull
    public StructureType<SurfaceGeyserStructure> type() {
        return (StructureType)WorldStructures.SurfaceGeyserType.value();
    }
}

