/*
 * Decompiled with CFR 0.152.
 */
package com.periut.cryonicconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.periut.cryonicconfig.UtilityCryonicConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ConfigStorage {
    private final Map<String, Object> configData = new HashMap<String, Object>();
    private final String modId;

    public ConfigStorage(String modId) {
        this.modId = modId;
    }

    public ConfigStorage(String modId, String filePath) {
        this.modId = modId;
        this.loadFromFile(filePath);
    }

    public void setInt(String key, int value) {
        this.configData.put(key, value);
        UtilityCryonicConfig.save();
    }

    public void setDouble(String key, double value) {
        this.configData.put(key, value);
        UtilityCryonicConfig.save();
    }

    public void setString(String key, String value) {
        this.configData.put(key, value);
        UtilityCryonicConfig.save();
    }

    public void setBoolean(String key, boolean value) {
        this.configData.put(key, value);
        UtilityCryonicConfig.save();
    }

    public int getInt(String key, int defaultValue) {
        if (UtilityCryonicConfig.SERVER_CONFIG.containsKey(this.modId) && UtilityCryonicConfig.SERVER_CONFIG.get((Object)this.modId).configData.containsKey(key)) {
            return UtilityCryonicConfig.SERVER_CONFIG.get(this.modId).getIntDirect(key, defaultValue);
        }
        return this.getIntDirect(key, defaultValue);
    }

    public double getDouble(String key, double defaultValue) {
        if (UtilityCryonicConfig.SERVER_CONFIG.containsKey(this.modId) && UtilityCryonicConfig.SERVER_CONFIG.get((Object)this.modId).configData.containsKey(key)) {
            return UtilityCryonicConfig.SERVER_CONFIG.get(this.modId).getDoubleDirect(key, defaultValue);
        }
        return this.getDoubleDirect(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        if (UtilityCryonicConfig.SERVER_CONFIG.containsKey(this.modId) && UtilityCryonicConfig.SERVER_CONFIG.get((Object)this.modId).configData.containsKey(key)) {
            return UtilityCryonicConfig.SERVER_CONFIG.get(this.modId).getStringDirect(key, defaultValue);
        }
        return this.getStringDirect(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (UtilityCryonicConfig.SERVER_CONFIG.containsKey(this.modId) && UtilityCryonicConfig.SERVER_CONFIG.get((Object)this.modId).configData.containsKey(key)) {
            return UtilityCryonicConfig.SERVER_CONFIG.get(this.modId).getBooleanDirect(key, defaultValue);
        }
        return this.getBooleanDirect(key, defaultValue);
    }

    private int getIntDirect(String key, int defaultValue) {
        if (!this.configData.containsKey(key)) {
            this.setInt(key, defaultValue);
        }
        return this.configData.getOrDefault(key, defaultValue) instanceof Number ? ((Number)this.configData.get(key)).intValue() : defaultValue;
    }

    private double getDoubleDirect(String key, double defaultValue) {
        if (!this.configData.containsKey(key)) {
            this.setDouble(key, defaultValue);
        }
        return this.configData.getOrDefault(key, defaultValue) instanceof Number ? ((Number)this.configData.get(key)).doubleValue() : defaultValue;
    }

    private String getStringDirect(String key, String defaultValue) {
        if (!this.configData.containsKey(key)) {
            this.setString(key, defaultValue);
        }
        return this.configData.getOrDefault(key, defaultValue) instanceof String ? (String)this.configData.get(key) : defaultValue;
    }

    private boolean getBooleanDirect(String key, boolean defaultValue) {
        if (!this.configData.containsKey(key)) {
            this.setBoolean(key, defaultValue);
        }
        return this.configData.getOrDefault(key, defaultValue) instanceof Boolean ? (Boolean)this.configData.get(key) : defaultValue;
    }

    public void saveToFile(String filePath) {
        try (FileWriter writer = new FileWriter(filePath);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(this.configData, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadFromFile(String filePath) {
        File configFile = new File(filePath);
        if (!configFile.exists()) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(configFile.toPath());){
            Gson gson = new Gson();
            Map loadedData = (Map)gson.fromJson((Reader)reader, HashMap.class);
            if (loadedData != null) {
                this.configData.putAll(loadedData);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sync(String key, Player player) {
        if (!this.configData.containsKey(key)) {
            return;
        }
        if (!player.isLocalPlayer()) {
            Object o = this.configData.get(key);
            if (o instanceof Number) {
                Number n = (Number)o;
                player.displayClientMessage(Component.nullToEmpty((String)("ccsync:" + this.modId + ":" + key + ":" + String.valueOf(n))), false);
            } else if (o instanceof Boolean) {
                Boolean b = (Boolean)o;
                player.displayClientMessage(Component.nullToEmpty((String)("ccsync:" + this.modId + ":" + key + ":" + b)), false);
            } else if (o instanceof String) {
                String s = (String)o;
                player.displayClientMessage(Component.nullToEmpty((String)("ccsync:" + this.modId + ":" + key + ":" + s)), false);
            }
        }
    }
}

