/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.SimpleInventoryState;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class BlockEntityDryingBasin
extends CyclopsBlockEntity {
    private static final int WOOD_IGNITION_TEMPERATURE = 573;
    private final SimpleInventory inventory;
    private final SingleUseTank tank;
    @NBTPersist
    private Float randomRotation = Float.valueOf(0.0f);
    @NBTPersist
    private int progress = 0;
    @NBTPersist
    private int fire = 0;
    private SingleCache<Pair<ItemStack, FluidStack>, Optional<RecipeHolder<RecipeDryingBasin>>> recipeCache;

    public BlockEntityDryingBasin(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_DRYING_BASIN.get(), blockPos, blockState);
        this.inventory = new SimpleInventory(1, 1){

            public boolean canPlaceItem(int i, ItemStack itemstack) {
                return this.getItem(0).isEmpty();
            }

            public void setItem(int slotId, ItemStack itemstack) {
                super.setItem(slotId, itemstack);
                BlockEntityDryingBasin.this.randomRotation = Float.valueOf(((BlockEntityDryingBasin)BlockEntityDryingBasin.this).level.random.nextFloat() * 360.0f);
                BlockEntityDryingBasin.this.sendUpdate();
            }
        };
        this.tank = new SingleUseTank(1000);
        this.inventory.addDirtyMarkListener(() -> ((BlockEntityDryingBasin)this).sendUpdate());
        this.tank.addDirtyMarkListener(() -> ((SimpleInventory)this.inventory).setChanged());
        this.recipeCache = new SingleCache((SingleCache.ICacheUpdater)new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeHolder<RecipeDryingBasin>>>(){

            public Optional<RecipeHolder<RecipeDryingBasin>> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.of((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(BlockEntityDryingBasin.this.getRegistry(), (RecipeInput)recipeInput, (Level)BlockEntityDryingBasin.this.getLevel());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.matches((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.matches((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight()));
            }
        });
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public int getFire() {
        return this.fire;
    }

    public void setFire(int fire) {
        this.fire = fire;
    }

    public SimpleInventory getInventory() {
        return this.inventory;
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    public void read(CompoundTag tag, HolderLookup.Provider provider) {
        this.inventory.readFromNBT(provider, tag, "inventory");
        this.tank.readFromNBT(provider, tag, "tank");
        super.read(tag, provider);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.inventory.writeToNBT(provider, tag, "inventory");
        this.tank.writeToNBT(provider, tag, "tank");
        super.saveAdditional(tag, provider);
    }

    protected RecipeType<RecipeDryingBasin> getRegistry() {
        return (RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get();
    }

    public Optional<RecipeHolder<RecipeDryingBasin>> getCurrentRecipe() {
        return (Optional)this.recipeCache.get((Object)Pair.of((Object)this.getInventory().getItem(0).copy(), (Object)FluidHelpers.copy((FluidStack)this.getTank().getFluid())));
    }

    public float getRandomRotation() {
        return this.randomRotation.floatValue();
    }

    public static class TickerClient
    implements BlockEntityTicker<BlockEntityDryingBasin> {
        public void tick(Level level, BlockPos pos, BlockState blockState, BlockEntityDryingBasin blockEntity) {
            if (blockEntity.getProgress() > 0 && level.random.nextInt(5) == 0) {
                BlockState blockStateFluid;
                if (!blockEntity.getTank().isEmpty() && (blockStateFluid = blockEntity.getTank().getFluid().getFluid().getFluidType().getBlockForFluidState((BlockAndTintGetter)level, pos, blockEntity.getTank().getFluid().getFluid().defaultFluidState())) != null) {
                    level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, blockStateFluid), (double)pos.getX() + Math.random() * 0.8 + 0.1, (double)pos.getY() + Math.random() * 0.1 + 0.9, (double)pos.getZ() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
                }
                if (!blockEntity.getInventory().getItem(0).isEmpty()) {
                    ItemStack itemStack = blockEntity.getInventory().getItem(0);
                    level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, itemStack), (double)pos.getX() + Math.random() * 0.8 + 0.1, (double)pos.getY() + Math.random() * 0.1 + 0.9, (double)pos.getZ() + Math.random() * 0.8 + 0.1, 0.0, 0.1, 0.0);
                }
            }
        }
    }

    public static class TickerServer
    extends BlockEntityTickerDelayed<BlockEntityDryingBasin> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityDryingBasin blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            Optional<RecipeHolder<RecipeDryingBasin>> currentRecipe = blockEntity.getCurrentRecipe();
            if (!blockEntity.getTank().isEmpty() && blockEntity.getTank().getFluid().getFluid().getFluidType().getTemperature(blockEntity.getTank().getFluid()) >= 573) {
                blockEntity.setFire(blockEntity.getFire() + 1);
                if (blockEntity.getFire() >= 100) {
                    level.setBlockAndUpdate(pos, Blocks.FIRE.defaultBlockState());
                } else if (level.isEmptyBlock(pos.relative(Direction.UP)) && level.random.nextInt(10) == 0) {
                    level.setBlockAndUpdate(pos.relative(Direction.UP), Blocks.FIRE.defaultBlockState());
                }
            } else if (currentRecipe.isPresent()) {
                RecipeDryingBasin recipe = (RecipeDryingBasin)currentRecipe.get().value();
                if (blockEntity.getProgress() >= recipe.getDuration()) {
                    int amount = FluidHelpers.getAmount((FluidStack)recipe.getInputFluid().orElse(FluidStack.EMPTY));
                    blockEntity.getTank().drain(amount, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack output = recipe.getOutputItemFirst();
                    if (!output.isEmpty()) {
                        output = output.copy();
                        blockEntity.getInventory().setItem(0, output);
                    } else {
                        blockEntity.getInventory().setItem(0, ItemStack.EMPTY);
                    }
                    if (recipe.getOutputFluid().isPresent() && blockEntity.getTank().fill(recipe.getOutputFluid().get(), IFluidHandler.FluidAction.EXECUTE) == 0) {
                        IntegratedDynamics.clog(org.apache.logging.log4j.Level.ERROR, "Encountered an invalid recipe: " + String.valueOf(currentRecipe.get().id()));
                    }
                    blockEntity.setProgress(0);
                } else {
                    blockEntity.setProgress(blockEntity.getProgress() + 1);
                    blockEntity.setChanged();
                }
                blockEntity.setFire(0);
            } else if (blockEntity.getProgress() > 0 || blockEntity.getFire() > 0) {
                blockEntity.setProgress(0);
                blockEntity.setFire(0);
                blockEntity.setChanged();
            }
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityDryingBasin> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityDryingBasin>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.ItemHandler.BLOCK, (blockEntity, direction) -> blockEntity.getInventory().getItemHandler());
            this.add(Capabilities.InventoryState.BLOCK, (blockEntity, direction) -> new SimpleInventoryState(blockEntity.getInventory()));
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> blockEntity.getTank());
            this.add(Capabilities.RecipeHandler.BLOCK, (blockEntity, direction) -> new RecipeHandlerDryingBasin(() -> ((BlockEntityDryingBasin)((Object)blockEntity)).getLevel(), (RecipeType)RegistryEntries.RECIPETYPE_DRYING_BASIN.get()));
        }
    }
}

