/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.inventory.container;

import net.minecraft.core.component.DataComponents;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.container.ItemInventoryContainer;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLabeller;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;
import org.cyclops.integrateddynamics.item.ItemLabeller;

public class ContainerLabeller
extends ItemInventoryContainer<ItemLabeller> {
    private SimpleInventory temporaryInputSlots = new SimpleInventory(1, 1);
    @OnlyIn(value=Dist.CLIENT)
    private ContainerScreenLabeller gui;

    public ContainerLabeller(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        this(id, inventory, ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer));
    }

    public ContainerLabeller(int id, Inventory inventory, ItemLocation itemLocation) {
        super((MenuType)RegistryEntries.CONTAINER_LABELLER.get(), id, inventory, itemLocation);
        this.addSlot((Slot)new SlotExtended((Container)this.temporaryInputSlots, 0, 8, 8));
        this.addPlayerInventory(this.player.getInventory(), 8, 31);
        if (inventory.player.level().isClientSide()) {
            this.temporaryInputSlots.addDirtyMarkListener(() -> {
                ItemStack itemStack = this.temporaryInputSlots.getItem(0);
                IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
                IVariableFacade variableFacade = registry.handle(ValueDeseralizationContext.of(inventory.player.level()), itemStack);
                String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(variableFacade.getId());
                if (label == null && !itemStack.isEmpty() && itemStack.has(DataComponents.CUSTOM_NAME)) {
                    label = itemStack.getHoverName().getString();
                }
                if (label != null) {
                    this.getGui().setText(label);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGui(ContainerScreenLabeller gui) {
        this.gui = gui;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ContainerScreenLabeller getGui() {
        return this.gui;
    }

    public ItemStack getItemStack() {
        return this.temporaryInputSlots.getItem(0);
    }

    protected int getSizeInventory() {
        return 1;
    }

    public void removed(Player player) {
        ItemStack itemStack;
        super.removed(player);
        if (!player.level().isClientSide() && !(itemStack = this.temporaryInputSlots.getItem(0)).isEmpty()) {
            Helpers.returnItemToPlayer(player, itemStack);
        }
    }

    public void setItemStackName(String name) {
        ItemStack itemStack = this.getItemStack();
        if (!itemStack.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)name)) {
                itemStack.remove(DataComponents.CUSTOM_NAME);
            } else {
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)name));
            }
        }
    }
}

