/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.IIdentifiableNetworkElement;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.blockentity.BlockEntityProxy;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.TileNetworkElement;

public class ProxyNetworkElement
extends TileNetworkElement<BlockEntityProxy>
implements IEventListenableNetworkElement<BlockEntityProxy>,
IIdentifiableNetworkElement {
    public static final ResourceLocation GROUP = ResourceLocation.fromNamespaceAndPath((String)"integrateddynamics", (String)"proxy");

    public ProxyNetworkElement(DimPos pos) {
        super(pos);
    }

    @Override
    public int getId() {
        return ((BlockEntityProxy)this.getTile().get()).getProxyId();
    }

    @Override
    public ResourceLocation getGroup() {
        return GROUP;
    }

    @Override
    public boolean onNetworkAddition(INetwork network) {
        if (super.onNetworkAddition(network)) {
            return NetworkHelpers.getPartNetwork(network).map(partNetwork -> {
                if (!partNetwork.addProxy(this.getId(), this.getPos())) {
                    IntegratedDynamics.clog(Level.WARN, "A proxy already existed in the network, this is possibly a result from item duplication.");
                    ((BlockEntityProxy)this.getTile().get()).generateNewProxyId();
                    return partNetwork.addProxy(this.getId(), this.getPos());
                }
                return true;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public void onNetworkRemoval(INetwork network) {
        super.onNetworkRemoval(network);
        NetworkHelpers.getPartNetwork(network).ifPresent(partNetwork -> partNetwork.removeProxy(this.getId()));
    }

    @Override
    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getChannel() {
        return 0;
    }

    @Override
    public int getConsumptionRate() {
        return GeneralConfig.proxyBaseConsumption;
    }

    @Override
    @Nullable
    public Optional<BlockEntityProxy> getNetworkEventListener() {
        return this.getTile();
    }

    @Override
    protected Class<BlockEntityProxy> getTileClass() {
        return BlockEntityProxy.class;
    }
}

